/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.web.config;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Path;
import java.util.Iterator;
import java.util.Set;
import net.wenzuo.atom.core.util.BusinessException;
import net.wenzuo.atom.core.util.Result;
import net.wenzuo.atom.core.util.ResultProvider;
import net.wenzuo.atom.core.util.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice
@ConditionalOnProperty(value={"atom.web.exception-handler"}, matchIfMissing=true)
public class WebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(WebExceptionHandler.class);

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BusinessException.class})
    public Result<?> handler(BusinessException e) {
        log.warn(e.getMessage(), (Throwable)e);
        return Result.fail((ResultProvider)e);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={ServiceException.class})
    public Result<?> handler(ServiceException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.fail((ResultProvider)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public Result<?> handler(MethodArgumentTypeMismatchException e) {
        log.warn("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d" + e.getMessage(), (Throwable)e);
        return Result.fail((int)400, (String)"\u8bf7\u6c42\u6570\u636e\u9519\u8bef");
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BindException.class})
    public Result<?> handler(BindException e) {
        FieldError fieldError = e.getFieldError();
        if (fieldError == null) {
            log.warn(e.getMessage(), (Throwable)e);
            return Result.fail((int)400, (String)"\u8bf7\u6c42\u6570\u636e\u9519\u8bef");
        }
        String field = fieldError.getField();
        String message = fieldError.getDefaultMessage();
        log.warn("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: [" + field + "] " + message, (Throwable)e);
        return Result.fail((int)400, (String)message);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<?> handler(ConstraintViolationException e) {
        Set violations = e.getConstraintViolations();
        if (violations == null) {
            log.warn(e.getMessage(), (Throwable)e);
            return Result.fail((int)400, (String)"\u8bf7\u6c42\u6570\u636e\u9519\u8bef");
        }
        Iterator iterator = violations.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation violation = (ConstraintViolation)iterator.next();
            Path propertyPath = violation.getPropertyPath();
            String message = violation.getMessage();
            log.warn("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: [" + propertyPath + "] " + message, (Throwable)e);
            return Result.fail((int)400, (String)message);
        }
        log.warn(e.getMessage(), (Throwable)e);
        return Result.fail((int)400, (String)"\u8bf7\u6c42\u6570\u636e\u9519\u8bef");
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result<?> handler(HttpMessageNotReadableException e) {
        Throwable t = e.getRootCause();
        if (t != null) {
            log.warn(t.getMessage(), (Throwable)e);
            return Result.fail((int)400, (String)"\u8bf7\u6c42\u6570\u636e\u9519\u8bef");
        }
        log.warn(e.getMessage(), (Throwable)e);
        return Result.fail((int)400, (String)"\u8bf7\u6c42\u6570\u636e\u9519\u8bef");
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result<?> handler(MissingServletRequestParameterException e) {
        log.warn("\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931\uff1a" + e.getParameterName(), (Throwable)e);
        return Result.fail((int)400, (String)"\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931");
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result<?> handler(HttpRequestMethodNotSupportedException e) {
        String method = e.getMethod();
        CharSequence[] supportedMethods = e.getSupportedMethods();
        if (supportedMethods == null) {
            log.warn("\u8bf7\u6c42\u65b9\u6cd5\u9519\u8bef: \u4e0d\u652f\u6301" + method, (Throwable)e);
            return Result.fail((int)400, (String)"\u8bf7\u6c42\u65b9\u6cd5\u9519\u8bef");
        }
        String methods = String.join((CharSequence)", ", supportedMethods);
        log.warn("\u8bf7\u6c42\u65b9\u6cd5\u9519\u8bef: \u4e0d\u652f\u6301" + method + ", \u652f\u6301" + methods, (Throwable)e);
        return Result.fail((int)400, (String)"\u8bf7\u6c42\u65b9\u6cd5\u9519\u8bef");
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Result<?> handler(HttpMediaTypeNotSupportedException e) {
        MediaType contentType = e.getContentType();
        if (contentType == null) {
            log.warn(e.getMessage(), (Throwable)e);
            return Result.fail((int)400, (String)"\u8bf7\u6c42\u5185\u5bb9\u7c7b\u578b\u9519\u8bef");
        }
        String message = "\u8bf7\u6c42\u5185\u5bb9\u7c7b\u578b\u9519\u8bef: \u4e0d\u652f\u6301" + contentType;
        log.warn(message, (Throwable)e);
        return Result.fail((int)400, (String)"\u8bf7\u6c42\u5185\u5bb9\u7c7b\u578b\u9519\u8bef");
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public Result<?> handler(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.fail((int)500, (String)"\u670d\u52a1\u7e41\u5fd9, \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

