/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.web.util;

import com.alibaba.excel.EasyExcel;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.function.Supplier;
import net.wenzuo.atom.core.util.JsonUtils;

public class ResponseUtils {
    private static final String TYPE_JSON = "application/json";
    private static final String TYPE_XLS = "application/vnd.ms-excel";
    private static final String TYPE_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

    public static void renderJson(ServletResponse response, Object object) {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType(TYPE_JSON);
        try (PrintWriter writer = response.getWriter();){
            String json = JsonUtils.toJson((Object)object);
            response.setContentLength(json.length());
            writer.print(json);
        }
    }

    public static void renderJson(ServletResponse response, String json) {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType(TYPE_JSON);
        try (PrintWriter writer = response.getWriter();){
            response.setContentLength(json.length());
            writer.print(json);
        }
    }

    public static void renderXlsx(HttpServletResponse response, String filename, Class head, Supplier<Collection> supplier) {
        filename = (String)(filename == null ? "\u8868\u683c" : filename) + ".xlsx";
        filename = URLEncoder.encode((String)filename, StandardCharsets.UTF_8);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType(TYPE_XLSX);
        response.setHeader("Content-Disposition", "attachment;filename=" + (String)filename + ";filename*=UTF-8''" + (String)filename);
        Collection data = supplier.get();
        try (ServletOutputStream out = response.getOutputStream();){
            EasyExcel.write((OutputStream)out, (Class)head).sheet("sheet1").doWrite(data);
        }
    }

    public static void renderXlsx(HttpServletResponse response, String filename, Class head, Collection<?> data) {
        ResponseUtils.renderXlsx(response, filename, head, () -> data);
    }
}

