/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.web.config;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.springframework.lang.NonNull;
import org.springframework.util.StreamUtils;

public class CachedRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] cachedBody;

    public CachedRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        ServletInputStream inputStream = request.getInputStream();
        this.cachedBody = StreamUtils.copyToByteArray((InputStream)inputStream);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new CachedServletInputStream(this.cachedBody);
    }

    public BufferedReader getReader() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.cachedBody);
        return new BufferedReader(new InputStreamReader(byteArrayInputStream));
    }

    @NonNull
    public String getCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    private static class CachedServletInputStream
    extends ServletInputStream {
        private final InputStream cachedInputStream;

        public CachedServletInputStream(byte[] cachedBody) {
            this.cachedInputStream = new ByteArrayInputStream(cachedBody);
        }

        public boolean isFinished() {
            try {
                return this.cachedInputStream.available() == 0;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }

        public int read() throws IOException {
            return this.cachedInputStream.read();
        }
    }
}

