/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.web.config;

import jakarta.annotation.Resource;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.wenzuo.atom.core.util.NanoIdUtils;
import net.wenzuo.atom.web.config.CachedRequestWrapper;
import net.wenzuo.atom.web.config.CachedResponseWrapper;
import net.wenzuo.atom.web.config.LoggingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StreamUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@ConditionalOnProperty(value={"atom.web.logging.enabled"}, matchIfMissing=true)
@Order(value=-50)
public class LoggingFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingFilter.class);
    private static final ThreadLocal<Long> TIMER = new ThreadLocal();
    private static final PathMatcher PATH_MATCHER = new AntPathMatcher();
    private static final String TRACE_ID = "Trace-Id";
    private static final String OPTIONS = "OPTIONS";
    @Resource
    private LoggingProperties loggingProperties;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Value(value="${spring.mvc.servlet.path:}")
    private String servletPath;

    protected boolean shouldNotFilter(@NonNull HttpServletRequest request) throws ServletException {
        if (!log.isInfoEnabled()) {
            return true;
        }
        String method = request.getMethod();
        if (OPTIONS.contains(method)) {
            return true;
        }
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("text/event-stream")) {
            return true;
        }
        String uri = request.getRequestURI().substring(this.contextPath.length() + this.servletPath.length());
        for (String path : this.loggingProperties.getInternalExcludePath()) {
            if (!PATH_MATCHER.match(path, uri)) continue;
            return true;
        }
        for (String path : this.loggingProperties.getExcludePath()) {
            if (!PATH_MATCHER.match(path, uri)) continue;
            return true;
        }
        for (String path : this.loggingProperties.getIncludePath()) {
            if (!PATH_MATCHER.match(path, uri)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        TIMER.set(System.currentTimeMillis());
        String traceId = NanoIdUtils.nanoId();
        response.setHeader(TRACE_ID, traceId);
        MDC.put((String)TRACE_ID, (String)traceId);
        HttpServletRequest requestToUse = this.loggingRequest(request);
        Object responseToUse = response;
        if (!(responseToUse instanceof CachedResponseWrapper)) {
            responseToUse = new CachedResponseWrapper(response);
        }
        try {
            filterChain.doFilter((ServletRequest)requestToUse, (ServletResponse)responseToUse);
        }
        finally {
            this.loggingResponse((CachedResponseWrapper)((Object)responseToUse));
            TIMER.remove();
            MDC.remove((String)TRACE_ID);
        }
    }

    private HttpServletRequest loggingRequest(HttpServletRequest request) throws IOException {
        Object requestToUse = request;
        StringBuilder msg = new StringBuilder();
        msg.append("REQUEST: ").append(requestToUse.getMethod()).append(' ').append(requestToUse.getRequestURI());
        StringBuilder payload = new StringBuilder();
        Map form = requestToUse.getParameterMap();
        Set keySet = form.keySet();
        if (!keySet.isEmpty()) {
            payload.append("?");
        }
        Iterator nameIterator = form.keySet().iterator();
        while (nameIterator.hasNext()) {
            String name = (String)nameIterator.next();
            List<String> values = Arrays.asList((String[])form.get(name));
            Iterator<String> valueIterator = values.iterator();
            while (valueIterator.hasNext()) {
                String value = valueIterator.next();
                payload.append(name);
                if (value == null) continue;
                payload.append('=').append(value);
                if (!valueIterator.hasNext()) continue;
                payload.append('&');
            }
            if (!nameIterator.hasNext()) continue;
            payload.append('&');
        }
        String contentType = requestToUse.getContentType();
        if (contentType != null && contentType.contains("application/json")) {
            if (!(requestToUse instanceof CachedRequestWrapper)) {
                requestToUse = new CachedRequestWrapper(request);
            }
            try (ServletInputStream inputStream = requestToUse.getInputStream();){
                payload.append(' ').append(StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
        }
        if (!payload.isEmpty()) {
            msg.append((CharSequence)payload);
        }
        log.info(msg.toString());
        return requestToUse;
    }

    private void loggingResponse(CachedResponseWrapper wrapper) throws IOException {
        StringBuilder msg = new StringBuilder();
        long time = System.currentTimeMillis() - TIMER.get();
        msg.append("RESPONSE: ").append(time).append("ms");
        msg.append(' ').append(wrapper.getStatus());
        String contentType = wrapper.getContentType();
        if (contentType != null && contentType.contains("application/json")) {
            String payload;
            try (InputStream is = wrapper.getContentInputStream();){
                payload = StreamUtils.copyToString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
            if (!payload.isEmpty()) {
                msg.append(' ').append(payload);
            }
        }
        wrapper.copyBodyToResponse();
        log.info(msg.toString());
    }
}

