/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.web.util;

import cn.hutool.core.util.StrUtil;
import cn.idev.excel.ExcelWriter;
import cn.idev.excel.FastExcel;
import cn.idev.excel.context.AnalysisContext;
import cn.idev.excel.event.AnalysisEventListener;
import cn.idev.excel.read.builder.ExcelReaderBuilder;
import cn.idev.excel.read.listener.ReadListener;
import cn.idev.excel.write.builder.ExcelWriterBuilder;
import cn.idev.excel.write.builder.ExcelWriterSheetBuilder;
import cn.idev.excel.write.handler.CellWriteHandler;
import cn.idev.excel.write.handler.WriteHandler;
import cn.idev.excel.write.handler.context.CellWriteHandlerContext;
import cn.idev.excel.write.metadata.WriteSheet;
import cn.idev.excel.write.metadata.fill.FillConfig;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public abstract class ExcelUtils {
    public static void setDownloadFilename(HttpServletResponse response, String filename) {
        filename = (String)(StrUtil.isEmpty((CharSequence)filename) ? "\u8868\u683c" : filename) + ".xlsx";
        filename = URLEncoder.encode((String)filename, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-Disposition", "attachment;filename=" + (String)filename + ";filename*=UTF-8''" + (String)filename);
    }

    public static <T> List<T> read(File file, Class<T> head) {
        return FastExcel.read((File)file, head, null).sheet().doReadSync();
    }

    public static <T> List<T> read(File file, Class<T> head, String sheetName) {
        return FastExcel.read((File)file, head, null).sheet(sheetName).doReadSync();
    }

    public static <T> List<T> read(File file, Class<T> head, Integer headRowNumber) {
        return ((ExcelReaderBuilder)FastExcel.read((File)file, head, null).headRowNumber(headRowNumber)).sheet().doReadSync();
    }

    public static <T> List<T> read(File file, Class<T> head, Integer headRowNumber, Integer sheetNo) {
        return ((ExcelReaderBuilder)FastExcel.read((File)file, head, null).headRowNumber(headRowNumber)).sheet(sheetNo).doReadSync();
    }

    public static <T> List<T> read(File file, Class<T> head, Integer headRowNumber, String sheetName) {
        return ((ExcelReaderBuilder)FastExcel.read((File)file, head, null).headRowNumber(headRowNumber)).sheet(sheetName).doReadSync();
    }

    public static <T> void read(File file, Class<T> head, ReadListener readListener) {
        FastExcel.read((File)file, head, (ReadListener)readListener).sheet().doRead();
    }

    public static <T> void read(File file, Class<T> head, ReadListener readListener, String sheetName) {
        FastExcel.read((File)file, head, (ReadListener)readListener).sheet(sheetName).doRead();
    }

    public static <T> void read(File file, Class<T> head, ReadListener readListener, Integer headRowNumber) {
        ((ExcelReaderBuilder)FastExcel.read((File)file, head, (ReadListener)readListener).headRowNumber(headRowNumber)).sheet().doRead();
    }

    public static <T> void read(File file, Class<T> head, ReadListener readListener, Integer headRowNumber, Integer sheetNo) {
        ((ExcelReaderBuilder)FastExcel.read((File)file, head, (ReadListener)readListener).headRowNumber(headRowNumber)).sheet(sheetNo).doRead();
    }

    public static <T> void read(File file, Class<T> head, ReadListener readListener, Integer headRowNumber, String sheetName) {
        ((ExcelReaderBuilder)FastExcel.read((File)file, head, (ReadListener)readListener).headRowNumber(headRowNumber)).sheet(sheetName).doRead();
    }

    public static <T> void read(File file, Class<T> head, BiConsumer<T, AnalysisContext> consumer) {
        FastExcel.read((File)file, head, new ConsumerReadListener<T>(consumer)).sheet().doRead();
    }

    public static <T> void read(File file, Class<T> head, BiConsumer<T, AnalysisContext> consumer, String sheetName) {
        FastExcel.read((File)file, head, new ConsumerReadListener<T>(consumer)).sheet(sheetName).doRead();
    }

    public static <T> void read(File file, Class<T> head, BiConsumer<T, AnalysisContext> consumer, Integer headRowNumber) {
        ((ExcelReaderBuilder)FastExcel.read((File)file, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet().doRead();
    }

    public static <T> void read(File file, Class<T> head, BiConsumer<T, AnalysisContext> consumer, Integer headRowNumber, Integer sheetNo) {
        ((ExcelReaderBuilder)FastExcel.read((File)file, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetNo).doRead();
    }

    public static <T> void read(File file, Class<T> head, BiConsumer<T, AnalysisContext> consumer, Integer headRowNumber, String sheetName) {
        ((ExcelReaderBuilder)FastExcel.read((File)file, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetName).doRead();
    }

    public static <T> void read(File file, Class<T> head, Consumer<T> consumer) {
        FastExcel.read((File)file, head, new ConsumerReadListener<T>(consumer)).sheet().doRead();
    }

    public static <T> void read(File file, Class<T> head, Consumer<T> consumer, String sheetName) {
        FastExcel.read((File)file, head, new ConsumerReadListener<T>(consumer)).sheet(sheetName).doRead();
    }

    public static <T> void read(File file, Class<T> head, Consumer<T> consumer, Integer headRowNumber) {
        ((ExcelReaderBuilder)FastExcel.read((File)file, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet().doRead();
    }

    public static <T> void read(File file, Class<T> head, Consumer<T> consumer, Integer headRowNumber, Integer sheetNo) {
        ((ExcelReaderBuilder)FastExcel.read((File)file, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetNo).doRead();
    }

    public static <T> void read(File file, Class<T> head, Consumer<T> consumer, Integer headRowNumber, String sheetName) {
        ((ExcelReaderBuilder)FastExcel.read((File)file, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetName).doRead();
    }

    public static <T> List<T> read(InputStream inputStream, Class<T> head) {
        return FastExcel.read((InputStream)inputStream, head, null).sheet().doReadSync();
    }

    public static <T> List<T> read(InputStream inputStream, Class<T> head, String sheetName) {
        return FastExcel.read((InputStream)inputStream, head, null).sheet(sheetName).doReadSync();
    }

    public static <T> List<T> read(InputStream inputStream, Class<T> head, Integer headRowNumber) {
        return ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, null).headRowNumber(headRowNumber)).sheet().doReadSync();
    }

    public static <T> List<T> read(InputStream inputStream, Class<T> head, Integer headRowNumber, Integer sheetNo) {
        return ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, null).headRowNumber(headRowNumber)).sheet(sheetNo).doReadSync();
    }

    public static <T> List<T> read(InputStream inputStream, Class<T> head, Integer headRowNumber, String sheetName) {
        return ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, null).headRowNumber(headRowNumber)).sheet(sheetName).doReadSync();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, ReadListener readListener) {
        FastExcel.read((InputStream)inputStream, head, (ReadListener)readListener).sheet().doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, ReadListener readListener, String sheetName) {
        FastExcel.read((InputStream)inputStream, head, (ReadListener)readListener).sheet(sheetName).doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, ReadListener readListener, Integer headRowNumber) {
        ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, (ReadListener)readListener).headRowNumber(headRowNumber)).sheet().doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, ReadListener readListener, Integer headRowNumber, Integer sheetNo) {
        ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, (ReadListener)readListener).headRowNumber(headRowNumber)).sheet(sheetNo).doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, ReadListener readListener, Integer headRowNumber, String sheetName) {
        ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, (ReadListener)readListener).headRowNumber(headRowNumber)).sheet(sheetName).doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, BiConsumer<T, AnalysisContext> consumer) {
        FastExcel.read((InputStream)inputStream, head, new ConsumerReadListener<T>(consumer)).sheet().doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, BiConsumer<T, AnalysisContext> consumer, String sheetName) {
        FastExcel.read((InputStream)inputStream, head, new ConsumerReadListener<T>(consumer)).sheet(sheetName).doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, BiConsumer<T, AnalysisContext> consumer, Integer headRowNumber) {
        ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet().doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, BiConsumer<T, AnalysisContext> consumer, Integer headRowNumber, Integer sheetNo) {
        ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetNo).doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, BiConsumer<T, AnalysisContext> consumer, Integer headRowNumber, String sheetName) {
        ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetName).doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, Consumer<T> consumer) {
        FastExcel.read((InputStream)inputStream, head, new ConsumerReadListener<T>(consumer)).sheet().doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, Consumer<T> consumer, String sheetName) {
        FastExcel.read((InputStream)inputStream, head, new ConsumerReadListener<T>(consumer)).sheet(sheetName).doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, Consumer<T> consumer, Integer headRowNumber) {
        ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet().doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, Consumer<T> consumer, Integer headRowNumber, Integer sheetNo) {
        ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetNo).doRead();
    }

    public static <T> void read(InputStream inputStream, Class<T> head, Consumer<T> consumer, Integer headRowNumber, String sheetName) {
        ((ExcelReaderBuilder)FastExcel.read((InputStream)inputStream, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetName).doRead();
    }

    public static <T> List<T> read(String path, Class<T> head) {
        return FastExcel.read((String)path, head, null).sheet().doReadSync();
    }

    public static <T> List<T> read(String path, Class<T> head, String sheetName) {
        return FastExcel.read((String)path, head, null).sheet(sheetName).doReadSync();
    }

    public static <T> List<T> read(String path, Class<T> head, Integer headRowNumber) {
        return ((ExcelReaderBuilder)FastExcel.read((String)path, head, null).headRowNumber(headRowNumber)).sheet().doReadSync();
    }

    public static <T> List<T> read(String path, Class<T> head, Integer headRowNumber, Integer sheetNo) {
        return ((ExcelReaderBuilder)FastExcel.read((String)path, head, null).headRowNumber(headRowNumber)).sheet(sheetNo).doReadSync();
    }

    public static <T> List<T> read(String path, Class<T> head, Integer headRowNumber, String sheetName) {
        return ((ExcelReaderBuilder)FastExcel.read((String)path, head, null).headRowNumber(headRowNumber)).sheet(sheetName).doReadSync();
    }

    public static <T> void read(String path, Class<T> head, ReadListener readListener) {
        FastExcel.read((String)path, head, (ReadListener)readListener).sheet().doRead();
    }

    public static <T> void read(String path, Class<T> head, ReadListener readListener, String sheetName) {
        FastExcel.read((String)path, head, (ReadListener)readListener).sheet(sheetName).doRead();
    }

    public static <T> void read(String path, Class<T> head, ReadListener readListener, Integer headRowNumber) {
        ((ExcelReaderBuilder)FastExcel.read((String)path, head, (ReadListener)readListener).headRowNumber(headRowNumber)).sheet().doRead();
    }

    public static <T> void read(String path, Class<T> head, ReadListener readListener, Integer headRowNumber, Integer sheetNo) {
        ((ExcelReaderBuilder)FastExcel.read((String)path, head, (ReadListener)readListener).headRowNumber(headRowNumber)).sheet(sheetNo).doRead();
    }

    public static <T> void read(String path, Class<T> head, ReadListener readListener, Integer headRowNumber, String sheetName) {
        ((ExcelReaderBuilder)FastExcel.read((String)path, head, (ReadListener)readListener).headRowNumber(headRowNumber)).sheet(sheetName).doRead();
    }

    public static <T> void read(String path, Class<T> head, BiConsumer<T, AnalysisContext> consumer) {
        FastExcel.read((String)path, head, new ConsumerReadListener<T>(consumer)).sheet().doRead();
    }

    public static <T> void read(String path, Class<T> head, BiConsumer<T, AnalysisContext> consumer, String sheetName) {
        FastExcel.read((String)path, head, new ConsumerReadListener<T>(consumer)).sheet(sheetName).doRead();
    }

    public static <T> void read(String path, Class<T> head, BiConsumer<T, AnalysisContext> consumer, Integer headRowNumber) {
        ((ExcelReaderBuilder)FastExcel.read((String)path, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet().doRead();
    }

    public static <T> void read(String path, Class<T> head, BiConsumer<T, AnalysisContext> consumer, Integer headRowNumber, Integer sheetNo) {
        ((ExcelReaderBuilder)FastExcel.read((String)path, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetNo).doRead();
    }

    public static <T> void read(String path, Class<T> head, BiConsumer<T, AnalysisContext> consumer, Integer headRowNumber, String sheetName) {
        ((ExcelReaderBuilder)FastExcel.read((String)path, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetName).doRead();
    }

    public static <T> void read(String path, Class<T> head, Consumer<T> consumer) {
        FastExcel.read((String)path, head, new ConsumerReadListener<T>(consumer)).sheet().doRead();
    }

    public static <T> void read(String path, Class<T> head, Consumer<T> consumer, String sheetName) {
        FastExcel.read((String)path, head, new ConsumerReadListener<T>(consumer)).sheet(sheetName).doRead();
    }

    public static <T> void read(String path, Class<T> head, Consumer<T> consumer, Integer headRowNumber) {
        ((ExcelReaderBuilder)FastExcel.read((String)path, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet().doRead();
    }

    public static <T> void read(String path, Class<T> head, Consumer<T> consumer, Integer headRowNumber, Integer sheetNo) {
        ((ExcelReaderBuilder)FastExcel.read((String)path, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetNo).doRead();
    }

    public static <T> void read(String path, Class<T> head, Consumer<T> consumer, Integer headRowNumber, String sheetName) {
        ((ExcelReaderBuilder)FastExcel.read((String)path, head, new ConsumerReadListener<T>(consumer)).headRowNumber(headRowNumber)).sheet(sheetName).doRead();
    }

    public static void write(File file, Collection<?> data) {
        ((ExcelWriterSheetBuilder)FastExcel.write((File)file).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(File file, Collection<?> data, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)FastExcel.write((File)file).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(File file, Collection<?> data, String sheetName) {
        ((ExcelWriterSheetBuilder)FastExcel.write((File)file).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(File file, List<List<String>> head, Collection<?> data) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(File file, List<List<String>> head, Collection<?> data, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(File file, List<List<String>> head, Collection<?> data, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(File file, Class<?> head, Collection<?> data) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(File file, Class<?> head, Collection<?> data, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(File file, Class<?> head, Collection<?> data, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(File file, Supplier<Collection<?>> supplier) {
        ((ExcelWriterSheetBuilder)FastExcel.write((File)file).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(File file, Supplier<Collection<?>> supplier, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)FastExcel.write((File)file).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(File file, Supplier<Collection<?>> supplier, String sheetName) {
        ((ExcelWriterSheetBuilder)FastExcel.write((File)file).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(File file, List<List<String>> head, Supplier<Collection<?>> supplier) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(File file, List<List<String>> head, Supplier<Collection<?>> supplier, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(File file, List<List<String>> head, Supplier<Collection<?>> supplier, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(File file, Class<?> head, Supplier<Collection<?>> supplier) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(File file, Class<?> head, Supplier<Collection<?>> supplier, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(File file, Class<?> head, Supplier<Collection<?>> supplier, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((File)file).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(OutputStream outputStream, Collection<?> data) {
        ((ExcelWriterSheetBuilder)FastExcel.write((OutputStream)outputStream).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(OutputStream outputStream, Collection<?> data, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)FastExcel.write((OutputStream)outputStream).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(OutputStream outputStream, Collection<?> data, String sheetName) {
        ((ExcelWriterSheetBuilder)FastExcel.write((OutputStream)outputStream).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(OutputStream outputStream, List<List<String>> head, Collection<?> data) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(OutputStream outputStream, List<List<String>> head, Collection<?> data, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(OutputStream outputStream, List<List<String>> head, Collection<?> data, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(OutputStream outputStream, Class<?> head, Collection<?> data) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(OutputStream outputStream, Class<?> head, Collection<?> data, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(OutputStream outputStream, Class<?> head, Collection<?> data, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(OutputStream outputStream, Supplier<Collection<?>> supplier) {
        ((ExcelWriterSheetBuilder)FastExcel.write((OutputStream)outputStream).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(OutputStream outputStream, Supplier<Collection<?>> supplier, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)FastExcel.write((OutputStream)outputStream).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(OutputStream outputStream, Supplier<Collection<?>> supplier, String sheetName) {
        ((ExcelWriterSheetBuilder)FastExcel.write((OutputStream)outputStream).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(OutputStream outputStream, List<List<String>> head, Supplier<Collection<?>> supplier) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(OutputStream outputStream, List<List<String>> head, Supplier<Collection<?>> supplier, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(OutputStream outputStream, List<List<String>> head, Supplier<Collection<?>> supplier, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(OutputStream outputStream, Class<?> head, Supplier<Collection<?>> supplier) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(OutputStream outputStream, Class<?> head, Supplier<Collection<?>> supplier, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(OutputStream outputStream, Class<?> head, Supplier<Collection<?>> supplier, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((OutputStream)outputStream).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(String path, Collection<?> data) {
        ((ExcelWriterSheetBuilder)FastExcel.write((String)path).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(String path, Collection<?> data, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)FastExcel.write((String)path).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(String path, Collection<?> data, String sheetName) {
        ((ExcelWriterSheetBuilder)FastExcel.write((String)path).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(String path, List<List<String>> head, Collection<?> data) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(String path, List<List<String>> head, Collection<?> data, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(String path, List<List<String>> head, Collection<?> data, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(String path, Class<?> head, Collection<?> data) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(String path, Class<?> head, Collection<?> data, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(String path, Class<?> head, Collection<?> data, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(data);
    }

    public static void write(String path, Supplier<Collection<?>> supplier) {
        ((ExcelWriterSheetBuilder)FastExcel.write((String)path).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(String path, Supplier<Collection<?>> supplier, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)FastExcel.write((String)path).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(String path, Supplier<Collection<?>> supplier, String sheetName) {
        ((ExcelWriterSheetBuilder)FastExcel.write((String)path).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(String path, List<List<String>> head, Supplier<Collection<?>> supplier) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(String path, List<List<String>> head, Supplier<Collection<?>> supplier, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(String path, List<List<String>> head, Supplier<Collection<?>> supplier, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(String path, Class<?> head, Supplier<Collection<?>> supplier) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet().registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(String path, Class<?> head, Supplier<Collection<?>> supplier, Integer sheetNo) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet(sheetNo).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void write(String path, Class<?> head, Supplier<Collection<?>> supplier, String sheetName) {
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)FastExcel.write((String)path).head(head)).sheet(sheetName).registerWriteHandler((WriteHandler)ExcelUtils.defaultCellStyle())).doWrite(supplier);
    }

    public static void fill(File file, File template, Collection<?> list) {
        FastExcel.write((File)file).withTemplate(template).sheet().doFill(list);
    }

    public static void fill(File file, File template, Collection<?> list, Integer sheetNo) {
        FastExcel.write((File)file).withTemplate(template).sheet(sheetNo).doFill(list);
    }

    public static void fill(File file, File template, Collection<?> list, String sheetName) {
        FastExcel.write((File)file).withTemplate(template).sheet(sheetName).doFill(list);
    }

    public static void fill(File file, File template, Map<String, Object> map) {
        FastExcel.write((File)file).withTemplate(template).sheet().doFill(map);
    }

    public static void fill(File file, File template, Map<String, Object> map, Integer sheetNo) {
        FastExcel.write((File)file).withTemplate(template).sheet(sheetNo).doFill(map);
    }

    public static void fill(File file, File template, Map<String, Object> map, String sheetName) {
        FastExcel.write((File)file).withTemplate(template).sheet(sheetName).doFill(map);
    }

    public static void fill(File file, File template, Object object) {
        FastExcel.write((File)file).withTemplate(template).sheet().doFill(object);
    }

    public static void fill(File file, File template, Object object, Integer sheetNo) {
        FastExcel.write((File)file).withTemplate(template).sheet(sheetNo).doFill(object);
    }

    public static void fill(File file, File template, Object object, String sheetName) {
        FastExcel.write((File)file).withTemplate(template).sheet(sheetName).doFill(object);
    }

    public static void fill(File file, File template, Collection<?> list, Map<String, Object> map) {
        try (ExcelWriter writer = FastExcel.write((File)file).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet().build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(map, writeSheet);
        }
    }

    public static void fill(File file, File template, Collection<?> list, Map<String, Object> map, Integer sheetNo) {
        try (ExcelWriter writer = FastExcel.write((File)file).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((Integer)sheetNo).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(map, writeSheet);
        }
    }

    public static void fill(File file, File template, Collection<?> list, Map<String, Object> map, String sheetName) {
        try (ExcelWriter writer = FastExcel.write((File)file).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((String)sheetName).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(map, writeSheet);
        }
    }

    public static void fill(File file, File template, Collection<?> list, Object object) {
        try (ExcelWriter writer = FastExcel.write((File)file).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet().build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(object, writeSheet);
        }
    }

    public static void fill(File file, File template, Collection<?> list, Object object, Integer sheetNo) {
        try (ExcelWriter writer = FastExcel.write((File)file).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((Integer)sheetNo).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(object, writeSheet);
        }
    }

    public static void fill(File file, File template, Collection<?> list, Object object, String sheetName) {
        try (ExcelWriter writer = FastExcel.write((File)file).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((String)sheetName).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(object, writeSheet);
        }
    }

    public static void fill(OutputStream outputStream, File template, Collection<?> list) {
        FastExcel.write((OutputStream)outputStream).withTemplate(template).sheet().doFill(list);
    }

    public static void fill(OutputStream outputStream, File template, Collection<?> list, Integer sheetNo) {
        FastExcel.write((OutputStream)outputStream).withTemplate(template).sheet(sheetNo).doFill(list);
    }

    public static void fill(OutputStream outputStream, File template, Collection<?> list, String sheetName) {
        FastExcel.write((OutputStream)outputStream).withTemplate(template).sheet(sheetName).doFill(list);
    }

    public static void fill(OutputStream outputStream, File template, Map<String, Object> map) {
        FastExcel.write((OutputStream)outputStream).withTemplate(template).sheet().doFill(map);
    }

    public static void fill(OutputStream outputStream, File template, Map<String, Object> map, Integer sheetNo) {
        FastExcel.write((OutputStream)outputStream).withTemplate(template).sheet(sheetNo).doFill(map);
    }

    public static void fill(OutputStream outputStream, File template, Map<String, Object> map, String sheetName) {
        FastExcel.write((OutputStream)outputStream).withTemplate(template).sheet(sheetName).doFill(map);
    }

    public static void fill(OutputStream outputStream, File template, Object object) {
        FastExcel.write((OutputStream)outputStream).withTemplate(template).sheet().doFill(object);
    }

    public static void fill(OutputStream outputStream, File template, Object object, Integer sheetNo) {
        FastExcel.write((OutputStream)outputStream).withTemplate(template).sheet(sheetNo).doFill(object);
    }

    public static void fill(OutputStream outputStream, File template, Object object, String sheetName) {
        FastExcel.write((OutputStream)outputStream).withTemplate(template).sheet(sheetName).doFill(object);
    }

    public static void fill(OutputStream outputStream, File template, Collection<?> list, Map<String, Object> map) {
        try (ExcelWriter writer = FastExcel.write((OutputStream)outputStream).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet().build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(map, writeSheet);
        }
    }

    public static void fill(OutputStream outputStream, File template, Collection<?> list, Map<String, Object> map, Integer sheetNo) {
        try (ExcelWriter writer = FastExcel.write((OutputStream)outputStream).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((Integer)sheetNo).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(map, writeSheet);
        }
    }

    public static void fill(OutputStream outputStream, File template, Collection<?> list, Map<String, Object> map, String sheetName) {
        try (ExcelWriter writer = FastExcel.write((OutputStream)outputStream).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((String)sheetName).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(map, writeSheet);
        }
    }

    public static void fill(OutputStream outputStream, File template, Collection<?> list, Object object) {
        try (ExcelWriter writer = FastExcel.write((OutputStream)outputStream).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet().build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(object, writeSheet);
        }
    }

    public static void fill(OutputStream outputStream, File template, Collection<?> list, Object object, Integer sheetNo) {
        try (ExcelWriter writer = FastExcel.write((OutputStream)outputStream).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((Integer)sheetNo).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(object, writeSheet);
        }
    }

    public static void fill(OutputStream outputStream, File template, Collection<?> list, Object object, String sheetName) {
        try (ExcelWriter writer = FastExcel.write((OutputStream)outputStream).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((String)sheetName).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(object, writeSheet);
        }
    }

    public static void fill(String path, File template, Collection<?> list) {
        FastExcel.write((String)path).withTemplate(template).sheet().doFill(list);
    }

    public static void fill(String path, File template, Collection<?> list, Integer sheetNo) {
        FastExcel.write((String)path).withTemplate(template).sheet(sheetNo).doFill(list);
    }

    public static void fill(String path, File template, Collection<?> list, String sheetName) {
        FastExcel.write((String)path).withTemplate(template).sheet(sheetName).doFill(list);
    }

    public static void fill(String path, File template, Map<String, Object> map) {
        FastExcel.write((String)path).withTemplate(template).sheet().doFill(map);
    }

    public static void fill(String path, File template, Map<String, Object> map, Integer sheetNo) {
        FastExcel.write((String)path).withTemplate(template).sheet(sheetNo).doFill(map);
    }

    public static void fill(String path, File template, Map<String, Object> map, String sheetName) {
        FastExcel.write((String)path).withTemplate(template).sheet(sheetName).doFill(map);
    }

    public static void fill(String path, File template, Object object) {
        FastExcel.write((String)path).withTemplate(template).sheet().doFill(object);
    }

    public static void fill(String path, File template, Object object, Integer sheetNo) {
        FastExcel.write((String)path).withTemplate(template).sheet(sheetNo).doFill(object);
    }

    public static void fill(String path, File template, Object object, String sheetName) {
        FastExcel.write((String)path).withTemplate(template).sheet(sheetName).doFill(object);
    }

    public static void fill(String path, File template, Collection<?> list, Map<String, Object> map) {
        try (ExcelWriter writer = FastExcel.write((String)path).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet().build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(map, writeSheet);
        }
    }

    public static void fill(String path, File template, Collection<?> list, Map<String, Object> map, Integer sheetNo) {
        try (ExcelWriter writer = FastExcel.write((String)path).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((Integer)sheetNo).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(map, writeSheet);
        }
    }

    public static void fill(String path, File template, Collection<?> list, Map<String, Object> map, String sheetName) {
        try (ExcelWriter writer = FastExcel.write((String)path).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((String)sheetName).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(map, writeSheet);
        }
    }

    public static void fill(String path, File template, Collection<?> list, Object object) {
        try (ExcelWriter writer = FastExcel.write((String)path).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet().build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(object, writeSheet);
        }
    }

    public static void fill(String path, File template, Collection<?> list, Object object, Integer sheetNo) {
        try (ExcelWriter writer = FastExcel.write((String)path).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((Integer)sheetNo).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(object, writeSheet);
        }
    }

    public static void fill(String path, File template, Collection<?> list, Object object, String sheetName) {
        try (ExcelWriter writer = FastExcel.write((String)path).withTemplate(template).build();){
            WriteSheet writeSheet = FastExcel.writerSheet((String)sheetName).build();
            FillConfig config = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
            writer.fill(list, config, writeSheet);
            writer.fill(object, writeSheet);
        }
    }

    private static CellWriteHandler defaultCellStyle() {
        return new CellWriteHandler(){

            public void afterCellDispose(CellWriteHandlerContext context) {
                XSSFColor bgColor;
                Cell cell = context.getCell();
                Row row = context.getRow();
                Workbook workbook = context.getWriteWorkbookHolder().getWorkbook();
                XSSFCellStyle cellStyle = (XSSFCellStyle)workbook.createCellStyle();
                Sheet sheet = context.getWriteSheetHolder().getSheet();
                Boolean isHead = context.getHead();
                sheet.setDefaultColumnWidth(22);
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                XSSFColor borderColor = new XSSFColor(new byte[]{-1, -1, -1});
                cellStyle.setTopBorderColor(borderColor);
                cellStyle.setBottomBorderColor(borderColor);
                cellStyle.setLeftBorderColor(borderColor);
                cellStyle.setRightBorderColor(borderColor);
                cellStyle.setBorderTop(BorderStyle.THIN);
                cellStyle.setBorderBottom(BorderStyle.THIN);
                cellStyle.setBorderLeft(BorderStyle.THIN);
                cellStyle.setBorderRight(BorderStyle.THIN);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                XSSFFont font = (XSSFFont)workbook.createFont();
                if (isHead.booleanValue()) {
                    row.setHeightInPoints(35.0f);
                    bgColor = new XSSFColor(new byte[]{72, 85, 106});
                    XSSFColor textColor = new XSSFColor(new byte[]{-1, -1, -1});
                    font.setFontName("\u5b8b\u4f53");
                    font.setBold(true);
                    font.setColor(textColor);
                    font.setFontHeightInPoints((short)14);
                } else {
                    row.setHeightInPoints(30.0f);
                    bgColor = new XSSFColor(new byte[]{-29, -24, -16});
                    XSSFColor textColor = new XSSFColor(new byte[]{0, 0, 0});
                    font.setFontName("\u5b8b\u4f53");
                    font.setColor(textColor);
                    font.setFontHeightInPoints((short)12);
                }
                cellStyle.setFillForegroundColor(bgColor);
                cellStyle.setFont((Font)font);
                cell.setCellStyle((CellStyle)cellStyle);
                context.getFirstCellData().setWriteCellStyle(null);
            }
        };
    }

    private static class ConsumerReadListener<T>
    extends AnalysisEventListener<T> {
        private final BiConsumer<T, AnalysisContext> consumer;

        public ConsumerReadListener(BiConsumer<T, AnalysisContext> consumer) {
            this.consumer = consumer;
        }

        public ConsumerReadListener(Consumer<T> consumer) {
            this.consumer = (data, context) -> consumer.accept(data);
        }

        public void invoke(T data, AnalysisContext context) {
            this.consumer.accept(data, context);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

