/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.web.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class IpUtils {
    private static final String COMMA = ",";

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (IpUtils.isValidIp(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (IpUtils.isValidIp(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (IpUtils.isValidIp(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_CLIENT_IP");
        if (IpUtils.isValidIp(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        if (IpUtils.isValidIp(ip)) {
            return ip;
        }
        ip = request.getRemoteAddr();
        if (IpUtils.isValidIp(ip)) {
            return ip;
        }
        return null;
    }

    private static boolean isValidIp(String ip) {
        return ip != null && !ip.isEmpty() && !"unknown".equalsIgnoreCase(ip);
    }

    private static List<String> getIps(String originIp) {
        if (originIp == null) {
            return null;
        }
        String[] ips = originIp.split(COMMA);
        return Arrays.stream(ips).map(String::trim).collect(Collectors.toList());
    }
}

