/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.feign.config;

import feign.FeignException;
import feign.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import net.wenzuo.atom.core.util.Result;
import net.wenzuo.atom.core.util.ResultProvider;
import net.wenzuo.atom.feign.config.ThirdException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.HttpMessageConverterCustomizer;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"atom.feign.decode"}, matchIfMissing=true)
@Component
public class FeignClientDecoder
extends SpringDecoder {
    private static final Logger log = LoggerFactory.getLogger(FeignClientDecoder.class);

    public FeignClientDecoder(ObjectFactory<HttpMessageConverters> messageConverters, ObjectProvider<HttpMessageConverterCustomizer> customizers) {
        super(messageConverters, customizers);
    }

    public Object decode(Response response, Type type) throws IOException, FeignException {
        int status = response.status();
        Object object = super.decode(response, type);
        if (object instanceof Result) {
            Result result = (Result)object;
            if (status < 400) {
                return result;
            }
            throw new ThirdException(status, (ResultProvider)result, response.request());
        }
        if (status < 400) {
            return object;
        }
        throw new ThirdException(status, response.request());
    }
}

