/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.feign.config;

import feign.FeignException;
import net.wenzuo.atom.core.util.Result;
import net.wenzuo.atom.core.util.ResultProvider;
import net.wenzuo.atom.feign.config.ThirdException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@ConditionalOnProperty(value={"atom.feign.exception-handler"}, matchIfMissing=true)
public class FeignExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(FeignExceptionHandler.class);

    @ResponseStatus(value=HttpStatus.BAD_GATEWAY)
    @ExceptionHandler(value={ThirdException.class})
    public Result<?> handler(ThirdException e) {
        log.error(e.getMessage(), (Throwable)((Object)e));
        return Result.fail((ResultProvider)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_GATEWAY)
    @ExceptionHandler(value={FeignException.class})
    public Result<?> handler(FeignException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.fail((int)500, (String)"\u7b2c\u4e09\u65b9\u670d\u52a1\u7e41\u5fd9, \u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

