/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.feign.config;

import feign.Logger;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"atom.feign.logging"}, matchIfMissing=true)
@Component
public class FeignLogger
extends feign.Logger {
    private static final ThreadLocal<Long> TIMER = new ThreadLocal();
    private final Logger logger;

    public FeignLogger() {
        this(feign.Logger.class);
    }

    public FeignLogger(Class<?> clazz) {
        this(LoggerFactory.getLogger(clazz));
    }

    public FeignLogger(String name) {
        this(LoggerFactory.getLogger((String)name));
    }

    FeignLogger(Logger logger) {
        this.logger = logger;
    }

    protected void logRequest(String configKey, Logger.Level logLevel, Request request) {
        TIMER.set(System.currentTimeMillis());
        String bodyText = null;
        if (request.body() != null) {
            String string = bodyText = request.charset() != null ? new String(request.body(), request.charset()) : null;
        }
        if (bodyText == null) {
            this.logger.info("THIRD-REQUEST: {} {}", (Object)request.httpMethod().name(), (Object)request.url());
            return;
        }
        this.logger.info("THIRD-REQUEST: {} {} {}", new Object[]{request.httpMethod().name(), request.url(), bodyText});
    }

    protected Response logAndRebufferResponse(String configKey, Logger.Level logLevel, Response response, long elapsedTime) throws IOException {
        int status = response.status();
        long time = System.currentTimeMillis() - TIMER.get();
        TIMER.remove();
        if (response.body() != null && status != 204 && status != 205) {
            byte[] bodyData = Util.toByteArray((InputStream)response.body().asInputStream());
            String bodyText = Util.decodeOrDefault((byte[])bodyData, (Charset)Util.UTF_8, null);
            this.logger.info("THIRD-RESPONSE: {}ms {} {}", new Object[]{time, status, bodyText});
            return response.toBuilder().body(bodyData).build();
        }
        this.logger.info("THIRD-RESPONSE: {}ms {}", (Object)time, (Object)status);
        return response;
    }

    protected void log(String configKey, String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format(FeignLogger.methodTag((String)configKey) + format, args));
        }
    }
}

