/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.kafka.config;

import jakarta.annotation.PostConstruct;
import net.wenzuo.atom.kafka.properties.KafkaProperties;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.support.GenericApplicationContext;

@ComponentScan(value={"net.wenzuo.atom.kafka"})
@ConfigurationPropertiesScan(value={"net.wenzuo.atom.kafka.properties"})
@ConditionalOnProperty(value={"atom.kafka.enabled"}, matchIfMissing=true)
public class KafkaAutoConfiguration {
    private final KafkaProperties kafkaProperties;
    private final GenericApplicationContext genericApplicationContext;

    @PostConstruct
    public void initKafkaTopics() {
        for (KafkaProperties.Topic topic : this.kafkaProperties.getTopics()) {
            this.genericApplicationContext.registerBean(topic.getName(), NewTopic.class, () -> new NewTopic(topic.getName(), topic.getNumPartitions().intValue(), topic.getReplicationFactor().shortValue()), new BeanDefinitionCustomizer[0]);
        }
    }

    public KafkaAutoConfiguration(KafkaProperties kafkaProperties, GenericApplicationContext genericApplicationContext) {
        this.kafkaProperties = kafkaProperties;
        this.genericApplicationContext = genericApplicationContext;
    }
}

