/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.kafka.service.impl;

import java.util.concurrent.CompletableFuture;
import net.wenzuo.atom.core.util.JsonUtils;
import net.wenzuo.atom.kafka.service.KafkaService;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class KafkaServiceImpl
implements KafkaService {
    private static final Logger log = LoggerFactory.getLogger(KafkaServiceImpl.class);
    private final KafkaTemplate<String, String> kafkaTemplate;

    @Override
    public void send(String topic, Object message) {
        this.send(topic, null, message);
    }

    @Override
    public void send(String topic, String key, Object message) {
        String json = JsonUtils.toJson((Object)message);
        ProducerRecord producerRecord = new ProducerRecord(topic, null, Long.valueOf(System.currentTimeMillis()), (Object)key, (Object)json);
        CompletableFuture future = this.kafkaTemplate.send(producerRecord);
        future.whenComplete((result, ex) -> {
            if (ex == null) {
                log.info("Kafka \u6d88\u606f\u53d1\u9001\u6210\u529f, TOPIC:{}, DATA:{}", (Object)topic, (Object)json);
            } else {
                log.error("Kafka \u6d88\u606f\u53d1\u9001\u5931\u8d25, {}", (Object)ex.getMessage());
            }
        });
    }

    public KafkaServiceImpl(KafkaTemplate<String, String> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

