/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.kafka;

import jakarta.annotation.PostConstruct;
import lombok.Generated;
import net.wenzuo.atom.kafka.KafkaProperties;
import net.wenzuo.atom.kafka.KafkaService;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.GenericApplicationContext;

@Import(value={KafkaService.class})
@EnableConfigurationProperties(value={KafkaProperties.class})
@ConditionalOnProperty(value={"atom.kafka.enabled"}, matchIfMissing=true)
public class KafkaAutoConfiguration {
    private final KafkaProperties kafkaProperties;
    private final GenericApplicationContext genericApplicationContext;

    @PostConstruct
    public void initKafkaTopics() {
        if (this.kafkaProperties.getTopics() != null) {
            for (KafkaProperties.Topic topic : this.kafkaProperties.getTopics()) {
                this.genericApplicationContext.registerBean(topic.getName(), NewTopic.class, () -> new NewTopic(topic.getName(), topic.getNumPartitions().intValue(), topic.getReplicationFactor().shortValue()), new BeanDefinitionCustomizer[0]);
            }
        }
    }

    @Generated
    public KafkaAutoConfiguration(KafkaProperties kafkaProperties, GenericApplicationContext genericApplicationContext) {
        this.kafkaProperties = kafkaProperties;
        this.genericApplicationContext = genericApplicationContext;
    }
}

