/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.kafka;

import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.wenzuo.atom.core.util.JsonUtils;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class KafkaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaService.class);
    private final KafkaTemplate<String, String> kafkaTemplate;

    public void send(String topic, Object message) {
        this.send(topic, null, message);
    }

    public void send(String topic, String key, Object message) {
        String json = JsonUtils.toJson((Object)message);
        ProducerRecord producerRecord = new ProducerRecord(topic, null, Long.valueOf(System.currentTimeMillis()), (Object)key, (Object)json);
        CompletableFuture future = this.kafkaTemplate.send(producerRecord);
        future.whenComplete((result, ex) -> {
            if (ex != null) {
                log.error("Kafka send error: {}", (Object)ex.getMessage());
            }
        });
    }

    @Generated
    public KafkaService(KafkaTemplate<String, String> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

