/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.base.config;

import cn.hutool.core.util.ArrayUtil;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import net.wenzuo.base.exception.ServiceException;
import net.wenzuo.base.util.Ret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice
public class ExceptionConfig {
    private static final Logger log = LoggerFactory.getLogger(ExceptionConfig.class);

    @ExceptionHandler(value={ServiceException.class})
    @ResponseBody
    public Ret<Void> handler(ServiceException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Ret.fail(e.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public Ret<Void> handler(IllegalArgumentException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Ret.fail(e.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public Ret<Void> handler(MissingServletRequestParameterException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Ret.fail("\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931: " + e.getParameterName());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseBody
    public Ret<Void> handler(MethodArgumentTypeMismatchException e) {
        log.error(e.getMessage(), (Throwable)e);
        Class type = e.getRequiredType();
        if (type == null) {
            return Ret.fail("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        String simpleName = type.getSimpleName();
        return Ret.fail("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d, \u9700\u8981 " + simpleName + ", \u5f97\u5230 " + e.getValue());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public Ret<Void> handler(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        FieldError fieldError = e.getFieldError();
        if (fieldError == null) {
            return Ret.badRequest();
        }
        return Ret.fail(fieldError.getDefaultMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    public Ret<Void> handler(ConstraintViolationException e) {
        log.error(e.getMessage(), (Throwable)e);
        Set violations = e.getConstraintViolations();
        Iterator iterator = violations.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation violation = (ConstraintViolation)iterator.next();
            return Ret.fail(violation.getMessage());
        }
        return Ret.badRequest();
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public Ret<Void> handler(HttpRequestMethodNotSupportedException e) {
        log.error(e.getMessage(), (Throwable)e);
        String method = e.getMethod();
        Object[] supportedMethods = e.getSupportedMethods();
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append("\u6b64\u63a5\u53e3\u4e0d\u652f\u6301 ").append(method).append(" \u8bf7\u6c42");
        if (ArrayUtil.isNotEmpty((Object[])supportedMethods)) {
            msgBuilder.append(", \u652f\u6301\u7684\u8bf7\u6c42\u7c7b\u578b\u4e3a [").append(ArrayUtil.join((Object[])supportedMethods, (CharSequence)", ")).append("]");
            return Ret.fail(msgBuilder.toString());
        }
        return Ret.fail(msgBuilder.toString());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public Ret<Void> handler(HttpMessageNotReadableException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Ret.fail("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef, \u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Ret<Void> handler(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return Ret.serverError();
    }
}

