/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.base.filter;

import cn.hutool.core.util.IdUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Component
public class HttpLoggingFilter
extends OncePerRequestFilter {
    private static final String X_REQUEST_ID = "X-Request-Id";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        boolean isFirstRequest;
        String requestId = request.getHeader(X_REQUEST_ID);
        if (!StringUtils.hasLength((String)requestId)) {
            requestId = IdUtil.fastSimpleUUID();
        }
        MDC.put((String)X_REQUEST_ID, (String)requestId);
        boolean bl = isFirstRequest = !this.isAsyncDispatch(request);
        if (isFirstRequest) {
            if (!(request instanceof ContentCachingRequestWrapper)) {
                request = new ContentCachingRequestWrapper(request);
            }
            if (!(response instanceof ContentCachingResponseWrapper)) {
                response = new ContentCachingResponseWrapper(response);
                response.addHeader(X_REQUEST_ID, requestId);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        MDC.remove((String)X_REQUEST_ID);
    }
}

