/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.base.interceptor;

public abstract class LoggingContextHolder {
    private static final ThreadLocal<LoggingContext> LOGGING_CONTEXT_THREAD_LOCAL = new ThreadLocal();

    public static void start() {
        LoggingContext context = new LoggingContext();
        context.startTime = System.currentTimeMillis();
        context.loggingBuilder = new StringBuilder();
        LOGGING_CONTEXT_THREAD_LOCAL.set(context);
    }

    public static StringBuilder append(String content) {
        LoggingContextHolder.check();
        LoggingContext context = LOGGING_CONTEXT_THREAD_LOCAL.get();
        return context.loggingBuilder.append(content);
    }

    public static long stop() {
        LoggingContextHolder.check();
        LoggingContext context = LOGGING_CONTEXT_THREAD_LOCAL.get();
        context.endTime = System.currentTimeMillis();
        return context.endTime - context.startTime;
    }

    public static StringBuilder get() {
        LoggingContextHolder.check();
        LoggingContext context = LOGGING_CONTEXT_THREAD_LOCAL.get();
        return context.loggingBuilder;
    }

    private static void check() {
        LoggingContext context = LOGGING_CONTEXT_THREAD_LOCAL.get();
        if (context == null) {
            throw new IllegalStateException("\u5fc5\u987b\u5148\u8c03\u7528start()\u65b9\u6cd5\u521d\u59cb\u5316");
        }
    }

    private static class LoggingContext {
        private long startTime;
        private long endTime;
        private StringBuilder loggingBuilder;

        private LoggingContext() {
        }
    }
}

