/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.base.interceptor;

import java.io.BufferedReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.wenzuo.base.interceptor.LoggingContextHolder;
import net.wenzuo.base.util.JsonUtil;
import net.wenzuo.base.util.RetEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Order(value=-1)
@Component
public class LoggingInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);
    private static final String FORM_DATA = "form-data";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        LoggingContextHolder.start();
        LoggingContextHolder.append("\n\u2554").append("============================================================");
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        LoggingContextHolder.append("\n\u2551 \u6267\u884c\u65b9\u6cd5: ").append(handlerMethod.toString());
        this.loggingRequest(request);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return;
        }
        boolean isSuccess = this.loggingResponse(response);
        long took = LoggingContextHolder.stop();
        StringBuilder loggingBuilder = LoggingContextHolder.get();
        loggingBuilder.append("\n\u2551 \u6267\u884c\u8017\u65f6: ").append(took).append("ms").append("\n\u255a").append("============================================================");
        if (!isSuccess || took > 3000L || ex != null) {
            log.error(loggingBuilder.toString());
            return;
        }
        if (took > 2000L) {
            log.warn(loggingBuilder.toString());
            return;
        }
        log.info(loggingBuilder.toString());
    }

    private void loggingRequest(HttpServletRequest request) throws Exception {
        String contentType = request.getContentType();
        LoggingContextHolder.append("\n\u2551 \u8bf7\u6c42\u5730\u5740: ").append(request.getRequestURL()).append("\n\u2551 \u8bf7\u6c42\u53c2\u6570: ");
        Map parameterMap = request.getParameterMap();
        if (parameterMap.size() > 0) {
            parameterMap.forEach((key, value) -> LoggingContextHolder.append(key).append("=").append(Arrays.toString(value)).append(" "));
        }
        if (contentType == null || !contentType.contains(FORM_DATA)) {
            String line;
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                LoggingContextHolder.append(line.trim());
            }
        }
    }

    private boolean loggingResponse(HttpServletResponse response) throws Exception {
        ContentCachingResponseWrapper wrapper = (ContentCachingResponseWrapper)response;
        byte[] byteArray = wrapper.getContentAsByteArray();
        String body = new String(byteArray, StandardCharsets.UTF_8);
        LoggingContextHolder.append("\n\u2551 \u54cd\u5e94\u53c2\u6570: ").append(body);
        wrapper.copyBodyToResponse();
        CodeWrapper codeWrapper = JsonUtil.parseObject(body, CodeWrapper.class);
        return codeWrapper == null || codeWrapper.getCode() == RetEnum.OK.code;
    }

    private static class CodeWrapper {
        private int code;

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CodeWrapper)) {
                return false;
            }
            CodeWrapper other = (CodeWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getCode() == other.getCode();
        }

        protected boolean canEqual(Object other) {
            return other instanceof CodeWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            return result;
        }

        public String toString() {
            return "LoggingInterceptor.CodeWrapper(code=" + this.getCode() + ")";
        }
    }
}

