/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.base.util;

import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import net.wenzuo.base.exception.ServiceException;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class Assert {
    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new ServiceException(message);
        }
    }

    public static void notNull(Object object, String template, Object ... values) {
        Assert.notNull(object, StrUtil.format((CharSequence)template, (Object[])values));
    }

    public static void notEmpty(Object[] array, String message) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            throw new ServiceException(message);
        }
    }

    public static void notEmpty(Object[] array, String template, Object ... values) {
        Assert.notEmpty(array, StrUtil.format((CharSequence)template, (Object[])values));
    }

    public static void notEmpty(@Nullable Collection<?> collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new ServiceException(message);
        }
    }

    public static void notEmpty(@Nullable Collection<?> collection, String template, Object ... values) {
        Assert.notEmpty(collection, StrUtil.format((CharSequence)template, (Object[])values));
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new ServiceException(message);
        }
    }

    public static void isTrue(boolean expression, String template, Object ... values) {
        Assert.isTrue(expression, StrUtil.format((CharSequence)template, (Object[])values));
    }

    public static void equals(String expected, String actual, String message) {
        if (Assert.objectsNotEqual(expected, actual)) {
            throw new ServiceException(message);
        }
    }

    public static void equals(String expected, String actual, String template, Object ... values) {
        Assert.equals(expected, actual, StrUtil.format((CharSequence)template, (Object[])values));
    }

    public static void equalsIgnoreCase(String expected, String actual, String message) {
        if (Assert.stringsNotEqual(expected, actual)) {
            throw new ServiceException(message);
        }
    }

    public static void equalsIgnoreCase(String expected, String actual, String template, Object ... values) {
        Assert.equalsIgnoreCase(expected, actual, StrUtil.format((CharSequence)template, (Object[])values));
    }

    private static boolean stringsNotEqual(String str1, String str2) {
        if (str1 == null) {
            return str2 != null;
        }
        return !str1.equalsIgnoreCase(str2);
    }

    private static boolean objectsNotEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 != null;
        }
        return !obj1.equals(obj2);
    }
}

