/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.base.util;

import javax.servlet.http.HttpServletRequest;

public class IpUtil {
    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (IpUtil.isValidIp(ip)) {
            return IpUtil.getFirstIp(ip);
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (IpUtil.isValidIp(ip)) {
            return IpUtil.getFirstIp(ip);
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (IpUtil.isValidIp(ip)) {
            return IpUtil.getFirstIp(ip);
        }
        ip = request.getHeader("HTTP_CLIENT_IP");
        if (IpUtil.isValidIp(ip)) {
            return IpUtil.getFirstIp(ip);
        }
        ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        if (IpUtil.isValidIp(ip)) {
            return IpUtil.getFirstIp(ip);
        }
        ip = request.getRemoteAddr();
        if (IpUtil.isValidIp(ip)) {
            return IpUtil.getFirstIp(ip);
        }
        return null;
    }

    private static boolean isValidIp(String ip) {
        return ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip);
    }

    private static String getFirstIp(String ip) {
        if (ip.contains(",")) {
            ip = ip.substring(0, ip.indexOf(",")).trim();
        }
        return ip;
    }
}

