/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.base.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = JsonUtil.configBuilder(null).build();

    public static <T> String toJsonString(T object) {
        try {
            return object == null ? null : OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(String jsonString, Class<T> type) {
        try {
            return (T)(jsonString == null ? null : OBJECT_MAPPER.readValue(jsonString, type));
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Jackson2ObjectMapperBuilder configBuilder(Jackson2ObjectMapperBuilder builder) {
        if (builder == null) {
            builder = new Jackson2ObjectMapperBuilder();
        }
        builder.locale(Locale.SIMPLIFIED_CHINESE);
        builder.timeZone("GMT+8");
        String dateFormat = "yyyy-MM-dd";
        String timeFormat = "HH:mm:ss";
        String datetimeFormat = "yyyy-MM-dd HH:mm:ss";
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(dateFormat);
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(timeFormat);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(datetimeFormat);
        builder.propertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        builder.serializationInclusion(JsonInclude.Include.NON_NULL);
        builder.simpleDateFormat(datetimeFormat);
        LocalDateSerializer localDateSerializer = new LocalDateSerializer(dateFormatter);
        LocalTimeSerializer localTimeSerializer = new LocalTimeSerializer(timeFormatter);
        LocalDateTimeSerializer localDateTimeSerializer = new LocalDateTimeSerializer(dateTimeFormatter);
        builder.serializers(new JsonSerializer[]{localDateSerializer, localTimeSerializer, localDateTimeSerializer});
        builder.featuresToEnable(new Object[]{SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS});
        builder.featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
        builder.featuresToDisable(new Object[]{SerializationFeature.FAIL_ON_EMPTY_BEANS});
        builder.featuresToEnable(new Object[]{SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS});
        builder.featuresToDisable(new Object[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
        LocalDateDeserializer localDateDeserializer = new LocalDateDeserializer(dateFormatter);
        LocalTimeDeserializer localTimeDeserializer = new LocalTimeDeserializer(timeFormatter);
        LocalDateTimeDeserializer localDateTimeDeserializer = new LocalDateTimeDeserializer(dateTimeFormatter);
        builder.deserializers(new JsonDeserializer[]{localDateDeserializer, localTimeDeserializer, localDateTimeDeserializer});
        return builder;
    }
}

