/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.base.util;

import java.math.BigInteger;
import java.util.Arrays;

public class ShortUuidUtil {
    private static final char[] CHAR_BASE = new char[]{'2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final BigInteger ALPHA_SIZE = BigInteger.valueOf(CHAR_BASE.length);

    public static String encode(String uuid) {
        int padToLen = 13;
        BigInteger value = new BigInteger(uuid, 16);
        StringBuilder shortUuid = new StringBuilder();
        while (value.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] fracAndRemainder = value.divideAndRemainder(ALPHA_SIZE);
            shortUuid.append(CHAR_BASE[fracAndRemainder[1].intValue()]);
            value = fracAndRemainder[0];
        }
        int padding = Math.max(padToLen - shortUuid.length(), 0);
        for (int i = 0; i < padding; ++i) {
            shortUuid.append(CHAR_BASE[0]);
        }
        return shortUuid.toString();
    }

    public static String decode(String encoded) {
        char[] chars = encoded.toCharArray();
        BigInteger sum = BigInteger.ZERO;
        int charLen = chars.length;
        for (int i = 0; i < charLen; ++i) {
            sum = sum.add(ALPHA_SIZE.pow(i).multiply(BigInteger.valueOf(Arrays.binarySearch(CHAR_BASE, chars[i]))));
        }
        String str = sum.toString(16);
        if (str.length() < 32) {
            str = String.format("%32s", str).replace(' ', '0');
        }
        return str;
    }
}

