/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class DebugPrintWriter
extends PrintWriter {
    private final PrintStream listener;

    public DebugPrintWriter(PrintWriter delegate) {
        this(delegate, System.out);
    }

    public DebugPrintWriter(PrintWriter delegate, PrintStream listener) {
        super(delegate);
        this.listener = listener;
    }

    @Override
    public void println() {
        super.println();
        this.listener.println();
    }

    @Override
    public void write(char[] buf, int off, int len) {
        super.write(buf, off, len);
        this.listener.write(new String(buf).getBytes(), off, len);
    }

    @Override
    public void write(int c) {
        super.write(c);
        this.listener.write(c);
    }

    @Override
    public void write(String s, int off, int len) {
        super.write(s, off, len);
        this.listener.write(s.getBytes(), off, len);
    }
}

