/*
 * Decompiled with CFR 0.152.
 */
package xapi.source;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Provider;
import xapi.inject.X_Inject;
import xapi.source.X_Modifier;
import xapi.source.api.HasQualifiedName;
import xapi.source.api.IsType;
import xapi.source.service.SourceService;
import xapi.util.X_String;
import xapi.util.api.Pair;
import xapi.util.impl.PairBuilder;

public class X_Source {
    private static final String arrays = "\\[\\]";
    private static final Provider<SourceService> service = X_Inject.singletonLazy(SourceService.class);

    private X_Source() {
    }

    public static IsType toType(Class<?> cls) {
        return ((SourceService)service.get()).toType(cls);
    }

    protected static IsType toType(String qualifiedName) {
        String pkg;
        return X_Source.toType(pkg, (pkg = X_Source.toPackage(qualifiedName)).length() == 0 ? qualifiedName : qualifiedName.substring(pkg.length() + 1));
    }

    public static IsType toType(String pkg, String enclosedName) {
        return ((SourceService)service.get()).toType(X_String.notNull(pkg).replace('/', '.'), enclosedName.replace('$', '.'));
    }

    public static IsType binaryToSource(String qualifiedBinaryName) {
        String pkg;
        int arrDepth = 0;
        while (qualifiedBinaryName.charAt(0) == '[') {
            ++arrDepth;
            qualifiedBinaryName = qualifiedBinaryName.substring(1);
        }
        int lastPkg = (qualifiedBinaryName = qualifiedBinaryName.replace('/', '.')).lastIndexOf(46);
        if (lastPkg == -1) {
            pkg = "";
        } else {
            pkg = qualifiedBinaryName.substring(0, lastPkg);
            assert (pkg.equals(pkg.toLowerCase())) : "Either you are using an uppercase letter in your package name (stop that!)\nor you are sending an inner class using period encoding instead of $ (also stop that!)\nYou sent " + qualifiedBinaryName + "; expected com.package.OuterClass$InnerClass";
        }
        String enclosed = X_Modifier.toEnclosingType((String)qualifiedBinaryName.substring(lastPkg + 1));
        return X_Source.toType(pkg, X_Modifier.addArrayBrackets((String)enclosed, (int)arrDepth));
    }

    public static String stripJarName(String loc) {
        int ind = loc.indexOf("jar!");
        if (ind == -1) {
            return loc;
        }
        return X_Source.stripFileName(loc.substring(0, ind + 3));
    }

    public static String stripFileName(String loc) {
        return loc.startsWith("file:") ? loc.substring(5) : loc;
    }

    public static String stripClassExtension(String loc) {
        return loc.endsWith(".class") ? loc.substring(0, loc.length() - 6) : loc;
    }

    public static String primitiveToObject(String datatype) {
        if ("int".equals(datatype)) {
            return "Integer";
        }
        if ("char".equals(datatype)) {
            return "Character";
        }
        return Character.toUpperCase(datatype.charAt(0)) + datatype.substring(1);
    }

    public static String[] toStringCanonical(Class<?> ... classes) {
        String[] names = new String[classes.length];
        int i = classes.length;
        while (i-- > 0) {
            names[i] = classes[i].getCanonicalName();
        }
        return names;
    }

    public static String[] toStringBinary(Class<?> ... classes) {
        String[] names = new String[classes.length];
        int i = classes.length;
        while (i-- > 0) {
            names[i] = classes[i].getName();
        }
        return names;
    }

    public static String toStringEnclosed(Class<?> cls) {
        return cls.getCanonicalName().replace(cls.getPackage().getName() + ".", "");
    }

    public static URL[] getUrls(ClassLoader classLoader) {
        ArrayList urls = new ArrayList();
        ClassLoader system = ClassLoader.getSystemClassLoader();
        while (classLoader != null && classLoader != system) {
            if (!(classLoader instanceof URLClassLoader)) continue;
            Collections.addAll(urls, ((URLClassLoader)classLoader).getURLs());
            classLoader = classLoader.getParent();
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static URL classToUrl(String binaryName, ClassLoader loader) {
        return loader.getResource(binaryName.replace('.', '/') + ".class");
    }

    public static String classToEnclosedSourceName(Class<?> cls) {
        return cls.getCanonicalName().substring(1 + cls.getPackage().getName().length());
    }

    public static boolean typesEqual(IsType[] one, IsType[] two) {
        if (one == null) {
            return two == null;
        }
        if (one.length != two.length) {
            return false;
        }
        int m = one.length;
        for (int i = 0; i < m; ++i) {
            if (one[i].equals(two[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean typesEqual(IsType[] one, Class<?> ... two) {
        if (one == null) {
            return two == null;
        }
        if (one.length != two.length) {
            return false;
        }
        int m = one.length;
        for (int i = 0; i < m; ++i) {
            if (one[i].getQualifiedName().equals(two[i].getCanonicalName())) continue;
            return false;
        }
        return true;
    }

    public static boolean typesEqual(Class<?>[] one, IsType ... two) {
        if (one == null) {
            return two == null;
        }
        if (one.length != two.length) {
            return false;
        }
        int m = one.length;
        for (int i = 0; i < m; ++i) {
            if (one[i].getCanonicalName().equals(two[i].getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    public static boolean typesEqual(Class<?>[] one, Class<?> ... two) {
        if (one == null) {
            return two == null;
        }
        if (one.length != two.length) {
            return false;
        }
        int m = one.length;
        for (int i = 0; i < m; ++i) {
            if (one[i] == two[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean typesAssignable(Class<?>[] subtypes, Class<?> ... supertypes) {
        if (subtypes == null) {
            return supertypes == null;
        }
        if (subtypes.length != supertypes.length) {
            return false;
        }
        int m = subtypes.length;
        for (int i = 0; i < m; ++i) {
            if (subtypes[i].isAssignableFrom(supertypes[i])) continue;
            return false;
        }
        return true;
    }

    public static IsType[] toTypes(String[] from) {
        IsType[] types = new IsType[from.length];
        for (String type : from) {
            types[i] = X_Source.toType(type);
        }
        return types;
    }

    public static String toPackage(String cls) {
        int lastPeriod = cls.lastIndexOf(46);
        while (lastPeriod != -1 && Character.isUpperCase(cls.charAt(lastPeriod + 1))) {
            lastPeriod = cls.lastIndexOf(46, lastPeriod - 1);
        }
        if (lastPeriod == -1) {
            return "";
        }
        return cls.substring(0, lastPeriod);
    }

    public static Pair<String, Integer> extractArrayDepth(String from) {
        int arrayDepth = 0;
        while (from.matches(".*\\[\\]")) {
            ++arrayDepth;
            from = from.replaceFirst(arrays, "");
        }
        return PairBuilder.pairOf((Object)from, (Object)arrayDepth);
    }

    public static boolean isJavaLangObject(HasQualifiedName type) {
        return type.getQualifiedName().equals("java.lang.Object");
    }

    public static String qualifiedName(String pkg, String enclosed) {
        return X_String.isEmpty(pkg) ? enclosed : pkg + "." + enclosed;
    }
}

