/*
 * Decompiled with CFR 0.152.
 */
package xapi.time;

import xapi.inject.X_Inject;
import xapi.time.api.Moment;
import xapi.time.impl.ImmutableMoment;
import xapi.time.service.TimeService;
import xapi.util.X_String;

public class X_Time {
    private static final TimeService service = (TimeService)X_Inject.singleton(TimeService.class);

    private X_Time() {
    }

    public static Moment now() {
        return service.now();
    }

    public static Moment threadStart() {
        return new ImmutableMoment(service.millis());
    }

    public static void tick() {
        service.tick();
    }

    public static Moment clone(Moment moment) {
        return service.clone(moment);
    }

    public static double birth() {
        return service.birth();
    }

    public static void runLater(Runnable runnable) {
        service.runLater(runnable);
    }

    public static String difference(Moment start, Moment finish) {
        return X_String.toMetricSuffix((finish.millis() - start.millis()) / 1000.0) + "seconds";
    }

    public static String difference(Moment start) {
        return X_Time.difference(start, X_Time.now());
    }

    public static void trySleep(int millis, int nanos) {
        assert (millis > 0 || nanos > 0);
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
        } else {
            try {
                Thread.sleep(millis, nanos);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static double nowPlus(double millis) {
        return X_Time.now().millis() + millis;
    }

    public static boolean isPast(double millis) {
        return millis < X_Time.now().millis();
    }

    public static boolean isFuture(double millis) {
        return millis > X_Time.now().millis();
    }

    public static String timestamp() {
        return service.timestamp();
    }
}

