/*
 * Decompiled with CFR 0.152.
 */
package xapi.time.api;

import xapi.util.X_String;

public class Clock {
    long startMilli;
    long startNano;
    long doneMilli;
    long doneNano;

    public Clock() {
        this.start();
    }

    public Clock(long startMilli, long startNano, long doneMilli, long doneNano) {
        this.startMilli = startMilli;
        this.startNano = startNano;
        this.doneMilli = doneMilli;
        this.doneNano = doneNano;
    }

    public double getTime() {
        double time = this.doneMilli - this.startMilli;
        if (time < 25.0) {
            return (double)Math.abs(this.doneNano - this.startNano) / 1.0E9;
        }
        return time / 1000.0;
    }

    public Clock start() {
        this.startMilli = System.currentTimeMillis();
        this.startNano = System.nanoTime();
        return this;
    }

    public Clock stop() {
        this.doneNano = System.nanoTime();
        this.doneMilli = System.currentTimeMillis();
        return this;
    }

    public String toString() {
        if (this.doneMilli == 0L) {
            this.stop();
        }
        return X_String.toMetricSuffix(this.getTime()) + " seconds";
    }
}

