/*
 * Decompiled with CFR 0.152.
 */
package xapi.time.impl;

import xapi.time.api.Moment;
import xapi.time.impl.ImmutableMoment;
import xapi.time.service.TimeService;

public abstract class AbstractTimeService
extends ImmutableMoment
implements TimeService {
    private static final long serialVersionUID = 1130197439830993337L;
    protected double now;
    private double delta;

    public AbstractTimeService() {
        super(System.currentTimeMillis());
    }

    @Override
    public double birth() {
        return super.millis();
    }

    @Override
    public Moment now() {
        return new ImmutableMoment(System.currentTimeMillis());
    }

    @Override
    public Moment clone(Moment moment) {
        return new ImmutableMoment(moment.millis());
    }

    @Override
    public double millis() {
        return this.now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Moment nowPlusOne() {
        double later;
        Double d = TimeService.second_to_nano;
        synchronized (d) {
            later = this.now + (this.delta += TimeService.second_to_nano.doubleValue());
        }
        return new ImmutableMoment(later);
    }

    @Override
    public void tick() {
        this.now = System.currentTimeMillis();
        this.delta = 0.0;
    }
}

