/*
 * Decompiled with CFR 0.152.
 */
package xapi.time.impl;

import xapi.time.X_Time;
import xapi.time.api.Moment;

public class ImmutableMoment
implements Moment {
    private static final long serialVersionUID = -5493139144266455063L;
    private final double millis;

    public ImmutableMoment(double millis) {
        this.millis = millis;
    }

    @Override
    public double millis() {
        return this.millis;
    }

    @Override
    public int compareTo(Moment o) {
        double delta = this.millis - o.millis();
        if (delta == 0.0) {
            return 0;
        }
        if (delta < 1.0 && delta > -1.0) {
            int bits = 0;
            double diff = Math.signum(delta);
            delta *= diff;
            while (delta < 1.0) {
                delta *= 2.0;
                bits = (int)((double)bits + diff);
            }
            return (int)(diff * (double)bits);
        }
        return (int)delta;
    }

    public int hashCode() {
        double delta = X_Time.birth() - this.millis;
        return (int)(delta < 1.0 ? 1.0E9 * delta : delta);
    }

    public boolean equals(Object obj) {
        return obj == this ? true : (obj instanceof Moment ? 0 == this.compareTo((Moment)obj) : false);
    }
}

