/*
 * Decompiled with CFR 0.152.
 */
package xapi.util;

import java.io.PrintStream;
import java.util.Arrays;
import xapi.log.X_Log;
import xapi.util.DefaultHandler;
import xapi.util.X_Runtime;
import xapi.util.X_Util;
import xapi.util.api.ErrorHandler;

public class X_Debug {
    private X_Debug() {
    }

    public static void debug(Throwable e) {
        while (e != null) {
            e.printStackTrace();
            if (e == e.getCause()) {
                return;
            }
            e = e.getCause();
        }
    }

    public static boolean isBenchmark() {
        return X_Runtime.isDebug();
    }

    public static void inspect(String qualifiedBinaryName) {
        X_Log.error((Object[])new Object[]{qualifiedBinaryName});
        if (X_Runtime.isDebug()) {
            StackTraceElement[] trace = new RuntimeException().getStackTrace();
            X_Log.error((Object[])new Object[]{Arrays.asList(trace).toString().replaceAll(", ", "\n  ")});
        }
    }

    public static ErrorHandler defaultHandler() {
        return DefaultHandler.handler;
    }

    public static void maybeRethrow(Throwable e) {
        Throwable unwrapped;
        if (X_Runtime.isDebug()) {
            X_Debug.debug(e);
        }
        if ((unwrapped = X_Util.unwrap((Throwable)e)) instanceof InterruptedException) {
            throw X_Util.rethrow((Throwable)e);
        }
    }

    public static RuntimeException rethrow(Throwable e) {
        X_Debug.debug(e);
        throw X_Util.rethrow((Throwable)e);
    }

    public static void traceSystemErr() {
        X_Debug.traceSystemErr(3);
    }

    public static void traceSystemErr(int ignoreDepth) {
        PrintStream orig = System.err;
        if (orig instanceof DebugStream) {
            return;
        }
        System.setErr(new DebugStream(orig, ignoreDepth));
        System.err.println("Tracing system.err");
    }

    public static void traceSystemOut() {
        X_Debug.traceSystemOut(3);
    }

    public static void traceSystemOut(int ignoreDepth) {
        PrintStream orig = System.out;
        if (orig instanceof DebugStream) {
            return;
        }
        System.setOut(new DebugStream(orig, ignoreDepth));
        System.out.println("Tracing system.out");
    }

    public static class DebugStream
    extends PrintStream {
        private final PrintStream orig;
        private final int depth;

        public DebugStream(PrintStream orig, int ignoreDepth) {
            super(orig);
            this.depth = ignoreDepth;
            this.orig = orig;
        }

        @Override
        public void println() {
            super.println();
            this.debugCaller();
        }

        private void debugCaller() {
            RuntimeException e = new RuntimeException();
            e.fillInStackTrace();
            StackTraceElement[] traces = e.getStackTrace();
            int end = Math.min(this.depth + 10, traces.length);
            this.orig.print("\n\t\t @ ");
            for (int index = this.depth; index < end; ++index) {
                this.orig.print(traces[index] + ": ");
            }
            if (X_Runtime.isJava()) {
                this.flush(this.orig);
            }
        }

        private void flush(PrintStream orig2) {
            this.orig.flush();
        }

        @Override
        public PrintStream append(CharSequence str) {
            this.print(str.toString());
            return this;
        }

        @Override
        public void print(String s) {
            super.print(s);
            this.debugCaller();
        }
    }
}

