/*
 * Decompiled with CFR 0.152.
 */
package xapi.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import xapi.annotation.gc.Indestructible;
import xapi.annotation.gc.OnGC;
import xapi.collect.impl.AbstractMultiInitMap;
import xapi.log.X_Log;
import xapi.util.X_Debug;
import xapi.util.X_Util;
import xapi.util.api.Destroyable;
import xapi.util.api.Destroyer;

public class X_GC {
    private static final GCMap destroyers = new GCMap();

    private X_GC() {
    }

    public static <T> void destroy(Class<? super T> classLiteral, T inst) {
        if (inst == null) {
            return;
        }
        OnGC gc = classLiteral.getAnnotation(OnGC.class);
        if (gc == null) {
            assert ("true".equals(System.getProperty("xapi.gcignore." + classLiteral.getName(), "false"))) : "Trying to call X_GC on a class without an OnGC annotation.\nTo suppress this assertion, set system property xapi.gcignore." + classLiteral.getName() + " to true";
            return;
        }
        ((Destroyer)destroyers.get(classLiteral, gc)).destroyObject(inst);
        while (classLiteral != Object.class) {
            gc = (classLiteral = classLiteral.getSuperclass()).getAnnotation(OnGC.class);
            if (gc == null) continue;
            X_GC.destroy(classLiteral, inst);
            return;
        }
    }

    private static boolean shouldSkip(Field f) {
        return f.getType().isPrimitive() || Modifier.isFinal(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || f.getAnnotation(Indestructible.class) != null || f.isSynthetic();
    }

    public static <T> void deepDestroy(Class<? super T> classLiteral, T inst) {
        X_GC.deepDestroy(classLiteral, inst, new HashSet<Object>());
        X_GC.destroy(classLiteral, inst);
    }

    public static <T> void deepDestroy(Class<? super T> classLiteral, T inst, HashSet<Object> seen) {
        for (Field f : classLiteral.getDeclaredFields()) {
            if (X_GC.shouldSkip(f)) continue;
            try {
                Object value;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((value = f.get(inst)) == null) continue;
                if (value instanceof Destroyable) {
                    ((Destroyable)value).destroy();
                }
                if (value.getClass().getAnnotation(OnGC.class) == null) continue;
                X_GC.destroy((Class)Class.class.cast(value.getClass()), value);
            }
            catch (Throwable e) {
                X_Debug.maybeRethrow(e);
            }
        }
    }

    private static final class GCMap
    extends AbstractMultiInitMap<Class<?>, Destroyer, OnGC> {
        private static final StaticGCMethods staticDestroyers = new StaticGCMethods();

        public GCMap() {
            super(CLASS_NAME);
        }

        protected Destroyer initialize(Class<?> cls, OnGC options) {
            final ArrayList<Method> zeroArg = new ArrayList<Method>();
            for (String method : options.instanceGCMethods()) {
                try {
                    Method m = cls.getMethod(method, new Class[0]);
                    if (m == null) {
                        m = cls.getDeclaredMethod(method, new Class[0]);
                    }
                    if (m == null) {
                        X_Log.warn((Object[])new Object[]{"Could not find instance level gc method ", method});
                        continue;
                    }
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                    }
                    assert (m.getTypeParameters().length == 0) : "Only zero-arg instance methods allowed on instance gc methods";
                    zeroArg.add(m);
                }
                catch (Throwable e) {
                    X_Debug.maybeRethrow(e);
                }
            }
            final ArrayList<Object> fieldDestroyers = new ArrayList<Object>();
            if (options.chainDeleteFields() || options.deleteInstanceFields()) {
                for (final Field f : cls.getDeclaredFields()) {
                    if (X_GC.shouldSkip(f)) continue;
                    try {
                        if (!f.isAccessible()) {
                            f.setAccessible(true);
                        }
                        final Destroyer setToNull = new Destroyer(){

                            public void destroyObject(Object toDestroy) {
                                try {
                                    f.set(toDestroy, null);
                                }
                                catch (Throwable e) {
                                    X_Debug.maybeRethrow(e);
                                }
                            }
                        };
                        if (options.chainDeleteFields()) {
                            fieldDestroyers.add(new Destroyer(){

                                public void destroyObject(Object toDestroy) {
                                    try {
                                        Object obj = f.get(toDestroy);
                                        if (obj != null) {
                                            Class<?> cls;
                                            OnGC anno;
                                            if (obj instanceof Destroyable) {
                                                ((Destroyable)obj).destroy();
                                            }
                                            if ((anno = (cls = obj.getClass()).getAnnotation(OnGC.class)) != null) {
                                                X_GC.destroy(cls, obj);
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                    setToNull.destroyObject(toDestroy);
                                }
                            });
                            continue;
                        }
                        fieldDestroyers.add(setToNull);
                    }
                    catch (Throwable e) {
                        X_Debug.maybeRethrow(e);
                    }
                }
            }
            final Destroyer instanceLevel = new Destroyer(){

                public void destroyObject(Object toDestroy) {
                    for (Method m : zeroArg) {
                        try {
                            m.invoke(toDestroy, new Object[0]);
                        }
                        catch (Throwable e) {
                            X_Debug.maybeRethrow(e);
                        }
                    }
                    for (Destroyer destroyer : fieldDestroyers) {
                        destroyer.destroyObject(toDestroy);
                    }
                }
            };
            if (options.staticGCMethods().length == 0) {
                return instanceLevel;
            }
            final ArrayList<Object> staticLevel = new ArrayList<Object>();
            for (String method : options.staticGCMethods()) {
                assert (!method.contains("(")) : "Do not send parantheses with method descriptions: " + method + " on " + cls;
                staticLevel.add(staticDestroyers.get(method, cls));
            }
            return new Destroyer(){

                public void destroyObject(Object toDestroy) {
                    for (Destroyer m : staticLevel) {
                        m.destroyObject(toDestroy);
                    }
                    instanceLevel.destroyObject(toDestroy);
                }
            };
        }
    }

    private static final class StaticGCMethods
    extends AbstractMultiInitMap<String, Destroyer, Class<?>> {
        public StaticGCMethods() {
            super(PASS_THRU);
        }

        protected Destroyer initialize(String method, Class<?> cls) {
            try {
                String[] bits = method.split("#");
                assert (bits.length == 2) : "[ERROR] Malformed static GC method " + method + "; \n" + "Proper syntax is com.package.Clazz$StaticInner#methodName";
                Class<?> toLoad = bits[0].equals(cls.getName()) ? cls : Class.forName(bits[0], true, cls.getClassLoader());
                final Method m = toLoad.getMethod(bits[1], Object.class);
                if (m == null) {
                    X_Log.warn((Object[])new Object[]{"Could not find static gc method ", method});
                    return Destroyer.NO_OP;
                }
                assert (m.getTypeParameters().length == 0) : "Only zero-arg instance methods allowed";
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return new Destroyer(){

                    public void destroyObject(Object toDestroy) {
                        try {
                            m.invoke(null, toDestroy);
                        }
                        catch (Throwable e) {
                            X_Debug.maybeRethrow(e);
                        }
                    }
                };
            }
            catch (Throwable e) {
                throw X_Util.rethrow((Throwable)e);
            }
        }
    }
}

