/*
 * Decompiled with CFR 0.152.
 */
package xapi.util;

import xapi.collect.api.CharPool;
import xapi.inject.X_Inject;
import xapi.util.service.StringService;

public class X_String {
    private X_String() {
    }

    public static byte[] getBytes(String source) {
        return source.getBytes();
    }

    public static CharPool getCharPool() {
        return (CharPool)X_Inject.singleton(CharPool.class);
    }

    public static String toMetricSuffix(double val) {
        String suffix = "";
        int index = 3;
        if (val > 1.0) {
            while (val >= 1000.0) {
                val /= 1000.0;
                if (++index != 6) continue;
            }
            suffix = StringService.metricSuffix[index];
            return (double)((int)(10.0 * val)) / 10.0 + suffix;
        }
        while (val < 1.0) {
            if (index == 0) {
                if (!(val < 0.1)) break;
                suffix = Double.toString(val);
                for (int pos = 2; pos < suffix.length(); ++pos) {
                    if (suffix.charAt(pos) == '0') continue;
                    suffix = suffix.substring(0, Math.min(pos + 1, suffix.length() - 1));
                    return suffix + StringService.metricSuffix[index];
                }
                return "0";
            }
            --index;
            val *= 1000.0;
        }
        suffix = StringService.metricSuffix[index];
        return (double)((int)(10.001 * val)) / 10.0 + suffix;
    }

    public static String toBinarySuffix(double val) {
        boolean neg;
        String suffix = "";
        boolean bl = neg = val < 0.0;
        if (neg) {
            val *= -1.0;
        }
        int index = 0;
        while (val >= 1024.0) {
            ++index;
            val /= 1024.0;
        }
        suffix = StringService.binarySuffix[Math.min(index, StringService.binarySuffix.length - 1)];
        return (neg ? "-" : "") + (double)((int)(10.0 * val)) / 10.0 + suffix;
    }

    public static <T> String joinObjects(T ... values) {
        return X_String.joinObjects(", ", values);
    }

    public static <T> String joinObjects(String separator, T ... values) {
        int i = values.length;
        String[] copy = new String[i];
        while (i-- > 0) {
            copy[i] = String.valueOf(values[i]);
        }
        return X_String.join(separator, copy);
    }

    public static String joinClasses(String separator, Class<?> ... values) {
        int i = values.length;
        String[] copy = new String[i];
        while (i-- > 0) {
            Class<?> cls = values[i];
            if (cls == null) continue;
            copy[i] = cls.getCanonicalName();
        }
        return X_String.join(separator, copy);
    }

    public static String joinStrings(String ... values) {
        return X_String.join(", ", values);
    }

    public static String join(String separator, String ... values) {
        if (values.length == 0) {
            return "";
        }
        char[] sep = separator.toCharArray();
        int totalSize = (values.length - 1) * sep.length;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                values[i] = "";
                continue;
            }
            totalSize += values[i].length();
        }
        char[] joined = new char[totalSize];
        int pos = 0;
        int end = values.length - 1;
        for (int i = 0; i < end; ++i) {
            System.arraycopy(values[i].toCharArray(), 0, joined, pos, values[i].length());
            System.arraycopy(sep, 0, joined, pos += values[i].length(), sep.length);
            pos += sep.length;
        }
        System.arraycopy(values[values.length - 1].toCharArray(), 0, joined, pos, values[values.length - 1].length());
        return new String(joined);
    }

    public static boolean isEmpty(String enclosing) {
        return enclosing == null || enclosing.length() == 0;
    }

    public static boolean isEmptyTrimmed(String enclosing) {
        return enclosing == null || enclosing.trim().length() == 0;
    }

    public static boolean isNotEmpty(String enclosing) {
        return enclosing != null && enclosing.length() > 0;
    }

    public static boolean isNotEmptyTrimmed(String enclosing) {
        return enclosing != null && enclosing.trim().length() > 0;
    }

    public static String firstChunk(String string, char c) {
        assert (string != null) : "No nulls to X_String.firstChunk, please.";
        char i = string.charAt(c);
        if (i == '\uffffffff') {
            return string;
        }
        return string.substring(0, i);
    }

    public static String firstNotEmpty(String groupId1, String groupId2) {
        return X_String.isEmptyTrimmed(groupId1) ? groupId2 : groupId1;
    }

    public static String[] splitNewLine(String str) {
        return str.split("\n");
    }

    public static String notNull(String str) {
        return str == null ? "" : str;
    }

    public static String chopOrReturnEmpty(String source, String match) {
        int ind = source.lastIndexOf(match);
        if (ind == -1) {
            return "";
        }
        return source.substring(0, ind);
    }

    public static String toTitleCase(String name) {
        return X_String.isEmpty(name) ? name : Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }
}

