/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.wouterdanes.docker.maven.DockerPluginError;
import net.wouterdanes.docker.maven.StartedContainerInfo;
import net.wouterdanes.docker.provider.DockerProvider;
import net.wouterdanes.docker.provider.DockerProviderSupplier;
import net.wouterdanes.docker.provider.model.BuiltImageInfo;
import net.wouterdanes.docker.provider.model.ImageBuildConfiguration;
import net.wouterdanes.docker.provider.model.PushableImage;
import net.wouterdanes.docker.remoteapi.exception.DockerException;
import net.wouterdanes.docker.remoteapi.model.ContainerInspectionResult;
import net.wouterdanes.docker.remoteapi.model.Credentials;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractDockerMojo
extends AbstractMojo {
    private static final String STARTED_CONTAINERS_KEY = "startedContainers";
    private static final String BUILT_IMAGES_KEY = "builtImages";
    private static final String PUSHABLE_IMAGES_KEY = "pushableImages";
    private static final String ERRORS_KEY = "errors";
    @Parameter(defaultValue="remote", property="docker.provider", required=true)
    private String providerName;
    @Parameter(defaultValue="false", property="docker.skip", required=false)
    private boolean skip;
    @Parameter(defaultValue="", property="docker.userName", required=false)
    private String userName;
    @Parameter(defaultValue="", property="docker.email", required=false)
    private String email;
    @Parameter(defaultValue="", property="docker.password", required=false)
    private String password;

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution skipped");
            return;
        }
        this.getLog().info((CharSequence)("Using docker provider: " + this.providerName));
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected void registerStartedContainer(String containerId, ContainerInspectionResult container) {
        StartedContainerInfo info = new StartedContainerInfo(containerId, container);
        Map startedContainers = this.obtainMapFromPluginContext(STARTED_CONTAINERS_KEY);
        startedContainers.put(containerId, info);
    }

    protected Collection<StartedContainerInfo> getStartedContainers() {
        Map map = this.obtainMapFromPluginContext(STARTED_CONTAINERS_KEY);
        return map.values();
    }

    protected Optional<StartedContainerInfo> getInfoForContainerStartId(String startId) {
        Map map = this.obtainMapFromPluginContext(STARTED_CONTAINERS_KEY);
        return Optional.ofNullable(map.get(startId));
    }

    protected void registerBuiltImage(String imageId, ImageBuildConfiguration imageConfig) throws MojoFailureException {
        BuiltImageInfo info = new BuiltImageInfo(imageId, imageConfig);
        Map builtImages = this.obtainMapFromPluginContext(BUILT_IMAGES_KEY);
        builtImages.put(info.getStartId(), info);
        if (imageConfig.isPush()) {
            this.enqueueForPushing(imageId, imageConfig);
        }
    }

    protected Collection<BuiltImageInfo> getBuiltImages() {
        Map builtImagesMap = this.obtainMapFromPluginContext(BUILT_IMAGES_KEY);
        return Collections.unmodifiableCollection(builtImagesMap.values());
    }

    protected void cleanUpStartedContainers() {
        ArrayList<String> stoppedContainerIds = new ArrayList<String>();
        Iterator<StartedContainerInfo> it = this.getStartedContainers().iterator();
        while (it.hasNext()) {
            String containerId = it.next().getContainerInfo().getId();
            this.getLog().info((CharSequence)String.format("Stopping container '%s'..", containerId));
            try {
                this.getDockerProvider().stopContainer(containerId);
                it.remove();
                stoppedContainerIds.add(containerId);
            }
            catch (DockerException e) {
                this.getLog().error((CharSequence)"Failed to stop container (this means it also won't be deleted)", (Throwable)e);
            }
        }
        for (String containerId : stoppedContainerIds) {
            this.getLog().info((CharSequence)String.format("Deleting container '%s'..", containerId));
            try {
                this.getDockerProvider().deleteContainer(containerId);
            }
            catch (DockerException e) {
                this.getLog().error((CharSequence)"Failed to delete container", (Throwable)e);
            }
        }
    }

    protected DockerProvider getDockerProvider() {
        DockerProvider provider = new DockerProviderSupplier(this.providerName).get();
        provider.setCredentials(this.getCredentials());
        provider.setLogger(this.getLog());
        return provider;
    }

    protected Credentials getCredentials() {
        if (StringUtils.isBlank((CharSequence)this.userName)) {
            this.getLog().debug((CharSequence)"No user name provided");
            return null;
        }
        this.getLog().debug((CharSequence)("Using credentials: " + this.userName));
        return new Credentials(this.userName, this.password, this.email, null);
    }

    protected Optional<BuiltImageInfo> getBuiltImageForStartId(String imageId) {
        Map builtImages = this.obtainMapFromPluginContext(BUILT_IMAGES_KEY);
        return Optional.ofNullable(builtImages.get(imageId));
    }

    protected void registerPluginError(DockerPluginError error) {
        List errors = this.obtainListFromPluginContext(ERRORS_KEY);
        errors.add(error);
    }

    protected List<DockerPluginError> getPluginErrors() {
        List list = this.obtainListFromPluginContext(ERRORS_KEY);
        return Collections.unmodifiableList(list);
    }

    protected void enqueueForPushing(String imageId, ImageBuildConfiguration imageConfig) throws MojoFailureException {
        this.enqueueForPushing(imageId, Optional.ofNullable(imageConfig.getNameAndTag()), Optional.ofNullable(imageConfig.getRegistry()));
    }

    protected void enqueueForPushing(String imageId, Optional<String> nameAndTag, Optional<String> registry) throws MojoFailureException {
        if (!registry.isPresent()) {
            this.enqueueForPushing(imageId, nameAndTag);
            return;
        }
        this.enqueueForPushingToRegistry(imageId, nameAndTag, registry.get());
    }

    protected void enqueueForPushingToRegistry(String imageId, Optional<String> nameAndTag, String registry) throws MojoFailureException {
        Objects.requireNonNull(nameAndTag.orElse(null), "When pushing to an explicit registry, name-and-tag must be set.");
        String newNameAndTag = registry + "/" + nameAndTag.get();
        this.attachTag(imageId, newNameAndTag);
        this.enqueueForPushing(imageId, Optional.ofNullable(newNameAndTag));
    }

    protected void enqueueForPushing(String imageId, Optional<String> nameAndTag) {
        this.getLog().info((CharSequence)String.format("Enqueuing image '%s' to be pushed with tag '%s'..", imageId, nameAndTag.orElse("<none>")));
        List images = this.obtainListFromPluginContext(PUSHABLE_IMAGES_KEY);
        PushableImage newImage = new PushableImage(imageId, nameAndTag);
        if (!images.contains(newImage)) {
            images.add(newImage);
        }
    }

    protected List<PushableImage> getImagesToPush() {
        List list = this.obtainListFromPluginContext(PUSHABLE_IMAGES_KEY);
        return Collections.unmodifiableList(list);
    }

    protected void attachTag(String imageId, String nameAndTag) throws MojoFailureException {
        try {
            this.getLog().info((CharSequence)String.format("Tagging image '%s' with tag '%s'..", imageId, nameAndTag));
            this.getDockerProvider().tagImage(imageId, nameAndTag);
        }
        catch (DockerException e) {
            String message = String.format("Failed to add tag '%s' to image '%s'", nameAndTag, imageId);
            this.handleDockerException(message, e);
        }
    }

    protected void handleDockerException(String message, DockerException e) throws MojoFailureException {
        Optional<String> apiResponse = e.getApiResponse();
        String exceptionMessage = apiResponse.isPresent() ? message + "\nApi response:\n" + apiResponse.get() : message;
        throw new MojoFailureException(exceptionMessage, (Throwable)e);
    }

    private <T> List<T> obtainListFromPluginContext(String name) {
        Object obj = this.getPluginContext().get(name);
        if (obj == null) {
            ArrayList list = new ArrayList();
            this.getPluginContext().put(name, list);
            return list;
        }
        return (List)obj;
    }

    private <T> Map<String, T> obtainMapFromPluginContext(String name) {
        Object obj = this.getPluginContext().get(name);
        if (obj == null) {
            HashMap map = new HashMap();
            this.getPluginContext().put(name, map);
            return map;
        }
        return (Map)obj;
    }
}

