/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.maven;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.wouterdanes.docker.maven.AbstractPreVerifyDockerMojo;
import net.wouterdanes.docker.maven.DockerPluginError;
import net.wouterdanes.docker.maven.StartedContainerInfo;
import net.wouterdanes.docker.provider.DockerProvider;
import net.wouterdanes.docker.provider.model.BuiltImageInfo;
import net.wouterdanes.docker.provider.model.ContainerStartConfiguration;
import net.wouterdanes.docker.provider.model.ExposedPort;
import net.wouterdanes.docker.remoteapi.exception.DockerException;
import net.wouterdanes.docker.remoteapi.model.ContainerInspectionResult;
import net.wouterdanes.docker.remoteapi.model.ContainerLink;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, name="start-containers", threadSafe=true, instantiationStrategy=InstantiationStrategy.PER_LOOKUP)
public class StartContainerMojo
extends AbstractPreVerifyDockerMojo {
    @Parameter(required=true)
    private List<ContainerStartConfiguration> containers;
    @Parameter
    private boolean forceCleanup;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;

    @Inject
    public StartContainerMojo(List<ContainerStartConfiguration> containers) {
        this.containers = containers;
    }

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.hasDuplicateIds() || this.hasInvalidLinks()) {
            return;
        }
        DockerProvider provider = this.getDockerProvider();
        for (ContainerStartConfiguration configuration : this.containers) {
            for (ContainerLink link : configuration.getLinks()) {
                String linkedContainerId = link.getContainerId();
                ContainerStartConfiguration startConfiguration = this.getContainerStartConfiguration(linkedContainerId);
                if (startConfiguration.getWaitForStartup() == null) continue;
                this.waitForContainerToFinishStartup(startConfiguration);
            }
            this.replaceImageWithBuiltImageIdIfInternalId(configuration);
            this.replaceLinkedContainerIdsWithStartedNames(configuration);
            try {
                this.getLog().info((CharSequence)String.format("Starting container '%s'..", configuration.getId()));
                ContainerInspectionResult container = provider.startContainer(configuration);
                String containerId = container.getId();
                List<ExposedPort> exposedPorts = provider.getExposedPorts(containerId);
                this.exposePortsToProject(configuration, exposedPorts);
                this.getLog().info((CharSequence)String.format("Started container with id '%s'", containerId));
                this.registerStartedContainer(configuration.getId(), container);
            }
            catch (DockerException e) {
                String message = String.format("Failed to start container '%s'", configuration.getId());
                this.handleDockerException(message, e);
            }
        }
        this.getLog().debug((CharSequence)("Properties after exposing ports: " + this.project.getProperties()));
        this.waitForContainersToFinishStartup();
        if (this.forceCleanup) {
            this.addShutdownHookToCleanUpContainers();
        }
    }

    private void addShutdownHookToCleanUpContainers() {
        this.getLog().info((CharSequence)"Started containers will be forcibly cleaned up when the build finishes");
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                StartContainerMojo.this.cleanUpStartedContainers();
            }
        }));
    }

    private ContainerStartConfiguration getContainerStartConfiguration(String id) {
        return this.containers.stream().filter(c -> c.getId().equals(id)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No container with ID '%s'", id)));
    }

    private void waitForContainersToFinishStartup() {
        this.containers.stream().filter(input -> input.getWaitForStartup() != null).forEach(this::waitForContainerToFinishStartup);
    }

    private void waitForContainerToFinishStartup(ContainerStartConfiguration container) {
        Pattern pattern = Pattern.compile(container.getWaitForStartup());
        Optional<StartedContainerInfo> startedContainerInfo = this.getInfoForContainerStartId(container.getId());
        if (!startedContainerInfo.isPresent()) {
            return;
        }
        StartedContainerInfo containerInfo = startedContainerInfo.get();
        String containerId = containerInfo.getContainerInfo().getId();
        long maxWait = System.currentTimeMillis() + (long)(1000 * container.getStartupTimeout());
        boolean finished = false;
        while (System.currentTimeMillis() <= maxWait) {
            String logs = this.getDockerProvider().getLogs(containerId);
            if (logs != null && pattern.matcher(logs).find()) {
                this.getLog().info((CharSequence)String.format("Container '%s' has completed startup", container.getId()));
                finished = true;
                break;
            }
            try {
                this.getLog().info((CharSequence)String.format("Waiting for container '%s' to finish startup (max %s sec.)", container.getId(), container.getStartupTimeout()));
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {
                break;
            }
        }
        if (!finished) {
            String message = String.format("Container %s did not finish startup in time", container.getId());
            this.registerPluginError(new DockerPluginError(this.getMojoGoalName(), message));
            this.getLog().error((CharSequence)message);
        }
    }

    private boolean hasInvalidLinks() {
        ArrayList<String> containerIds = new ArrayList<String>();
        boolean hasInvalidLinks = false;
        for (ContainerStartConfiguration configuration : this.containers) {
            List<ContainerLink> links = configuration.getLinks();
            for (ContainerLink link : links) {
                if (containerIds.contains(link.getContainerId())) continue;
                String message = String.format("Container '%s' tries to link to container '%s' that is not started before this container.", configuration.getId(), link.getContainerId());
                this.getLog().error((CharSequence)message);
                this.registerPluginError(new DockerPluginError(this.mojoExecution.getGoal(), message));
                hasInvalidLinks = true;
            }
            containerIds.add(configuration.getId());
        }
        return hasInvalidLinks;
    }

    private boolean hasDuplicateIds() {
        HashSet<String> ids = new HashSet<String>(this.containers.size());
        for (ContainerStartConfiguration configuration : this.containers) {
            if (ids.contains(configuration.getId())) {
                String message = String.format("Container ID '%s' used twice, Container IDs should be unique!", configuration.getId());
                this.getLog().error((CharSequence)message);
                this.registerPluginError(new DockerPluginError(this.mojoExecution.getGoal(), message));
                return true;
            }
            ids.add(configuration.getId());
        }
        return false;
    }

    private void exposePortsToProject(ContainerStartConfiguration configuration, List<ExposedPort> exposedPorts) {
        exposedPorts.parallelStream().forEach(port -> {
            String prefix = String.format("docker.containers.%s.ports.%s.", configuration.getId(), port.getContainerPort());
            this.addPropertyToProject(prefix + "host", port.getHost());
            this.addPropertyToProject(prefix + "port", String.valueOf(port.getExternalPort()));
        });
    }

    private void replaceImageWithBuiltImageIdIfInternalId(ContainerStartConfiguration configuration) {
        Optional<BuiltImageInfo> builtImage = this.getBuiltImageForStartId(configuration.getImage());
        if (builtImage.isPresent()) {
            configuration.fromImage(builtImage.get().getImageId());
        }
    }

    private void replaceLinkedContainerIdsWithStartedNames(ContainerStartConfiguration configuration) {
        for (ContainerLink link : configuration.getLinks()) {
            String containerId = link.getContainerId();
            String name = this.getStartedContainers().stream().filter(input -> input.getContainerId().equals(containerId)).findFirst().get().getContainerInfo().getName();
            link.toContainer(name);
        }
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setMojoExecution(MojoExecution mojoExecution) {
        this.mojoExecution = mojoExecution;
    }

    private void addPropertyToProject(String key, String value) {
        this.getLog().info((CharSequence)String.format("Setting property '%s' to '%s'", key, value));
        this.project.getProperties().setProperty(key, value);
    }

    @Override
    protected String getMojoGoalName() {
        return "start-containers";
    }
}

