/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.maven;

import java.util.List;
import java.util.Optional;
import net.wouterdanes.docker.maven.AbstractDockerMojo;
import net.wouterdanes.docker.provider.model.BuiltImageInfo;
import net.wouterdanes.docker.provider.model.ImageTagConfiguration;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(defaultPhase=LifecyclePhase.INSTALL, name="tag-images", threadSafe=true, instantiationStrategy=InstantiationStrategy.PER_LOOKUP)
public class TagImageMojo
extends AbstractDockerMojo {
    @Parameter(required=true)
    private List<ImageTagConfiguration> images;

    public void setImages(List<ImageTagConfiguration> images) {
        this.images = images;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        for (ImageTagConfiguration config : this.images) {
            if (config.getTags().isEmpty()) continue;
            this.applyTagsToImage(config);
        }
    }

    private void applyTagsToImage(ImageTagConfiguration config) throws MojoFailureException {
        String imageId = config.getId();
        boolean push = config.isPush();
        Optional<String> registry = Optional.ofNullable(config.getRegistry());
        Optional<BuiltImageInfo> builtInfo = this.getBuiltImageForStartId(imageId);
        if (builtInfo.isPresent()) {
            imageId = builtInfo.get().getImageId();
            registry = Optional.ofNullable(registry.orElse(builtInfo.get().getRegistry().orElse(null)));
        }
        for (String nameAndTag : config.getTags()) {
            this.attachTag(imageId, nameAndTag);
            if (!push) continue;
            this.enqueueForPushing(imageId, Optional.ofNullable(nameAndTag), registry);
        }
    }
}

