/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.maven;

import java.util.List;
import java.util.stream.Collectors;
import net.wouterdanes.docker.maven.AbstractDockerMojo;
import net.wouterdanes.docker.maven.DockerPluginError;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, instantiationStrategy=InstantiationStrategy.PER_LOOKUP)
public class VerifyMojo
extends AbstractDockerMojo {
    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        List<DockerPluginError> errors = this.getPluginErrors();
        if (!errors.isEmpty()) {
            List erroneousGoals = errors.stream().map(DockerPluginError::getPluginGoal).collect(Collectors.toList());
            StringBuilder sb = new StringBuilder("The following plugin goals had errors: \n");
            for (String goal : erroneousGoals) {
                sb.append(" - ").append(goal).append('\n');
            }
            this.getLog().error((CharSequence)sb);
            throw new MojoFailureException("Errors occurred, stopping the build");
        }
    }
}

