/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wouterdanes.docker.provider.RemoteApiBasedDockerProvider;
import net.wouterdanes.docker.provider.model.ContainerStartConfiguration;
import net.wouterdanes.docker.provider.model.ExposedPort;
import net.wouterdanes.docker.remoteapi.model.ContainerInspectionResult;
import net.wouterdanes.docker.remoteapi.model.ContainerStartRequest;

public class LocalDockerProvider
extends RemoteApiBasedDockerProvider {
    private static final Pattern TCP_PORT_MATCHER = Pattern.compile("(?<port>[0-9]+)/tcp");

    @Override
    public ContainerInspectionResult startContainer(ContainerStartConfiguration configuration) {
        ContainerStartRequest startRequest = new ContainerStartRequest().withLinks(configuration.getLinks());
        return super.startContainer(configuration, startRequest);
    }

    @Override
    public List<ExposedPort> getExposedPorts(String containerId) {
        ContainerInspectionResult containerInspectionResult = this.getContainersService().inspectContainer(containerId);
        if (containerInspectionResult.getNetworkSettings().getPorts().isEmpty()) {
            return Collections.emptyList();
        }
        Set<String> ports = containerInspectionResult.getConfig().getExposedPorts().keySet();
        String containerIp = containerInspectionResult.getNetworkSettings().getIpAddress();
        ArrayList<ExposedPort> exposedPorts = new ArrayList<ExposedPort>(ports.size());
        for (String port : ports) {
            Matcher matcher = TCP_PORT_MATCHER.matcher(port);
            if (!matcher.matches()) continue;
            int tcpPort = Integer.parseInt(matcher.group("port"));
            exposedPorts.add(new ExposedPort(port, tcpPort, containerIp));
        }
        return exposedPorts;
    }
}

