/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.provider;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.wouterdanes.docker.provider.DockerProvider;
import net.wouterdanes.docker.provider.model.Artifact;
import net.wouterdanes.docker.provider.model.ContainerCommitConfiguration;
import net.wouterdanes.docker.provider.model.ContainerStartConfiguration;
import net.wouterdanes.docker.provider.model.ImageBuildConfiguration;
import net.wouterdanes.docker.remoteapi.BaseService;
import net.wouterdanes.docker.remoteapi.ContainersService;
import net.wouterdanes.docker.remoteapi.ImagesService;
import net.wouterdanes.docker.remoteapi.MiscService;
import net.wouterdanes.docker.remoteapi.exception.ImageNotFoundException;
import net.wouterdanes.docker.remoteapi.model.ContainerCreateRequest;
import net.wouterdanes.docker.remoteapi.model.ContainerInspectionResult;
import net.wouterdanes.docker.remoteapi.model.ContainerStartRequest;
import net.wouterdanes.docker.remoteapi.model.Credentials;
import net.wouterdanes.docker.remoteapi.util.DockerHostFromEnvironmentSupplier;
import net.wouterdanes.docker.remoteapi.util.DockerHostFromPropertySupplier;
import net.wouterdanes.docker.remoteapi.util.DockerPortFromEnvironmentSupplier;
import net.wouterdanes.docker.remoteapi.util.DockerPortFromPropertySupplier;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.maven.plugin.logging.Log;

public abstract class RemoteApiBasedDockerProvider
implements DockerProvider {
    private final String host;
    private final int port;
    private final ContainersService containersService;
    private final ImagesService imagesService;
    private final MiscService miscService;
    private final Set<BaseService> services;
    private Log log;
    private static final int DEFAULT_DOCKER_PORT = 2375;
    private static final String DEFAULT_DOCKER_HOST = "127.0.0.1";
    public static final String DOCKER_HOST_SYSTEM_ENV = "DOCKER_HOST";
    public static final String DOCKER_HOST_PROPERTY = "docker.host";
    public static final String DOCKER_PORT_PROPERTY = "docker.port";
    public static final String TCP_PROTOCOL = "tcp";

    public RemoteApiBasedDockerProvider() {
        this(RemoteApiBasedDockerProvider.getDockerHostFromEnvironment(), RemoteApiBasedDockerProvider.getDockerPortFromEnvironment());
    }

    @Override
    public void setCredentials(Credentials credentials) {
        for (BaseService service : this.services) {
            service.setCredentials(credentials);
        }
    }

    @Override
    public void stopContainer(String containerId) {
        this.getContainersService().stopContainer(containerId);
    }

    @Override
    public void deleteContainer(String containerId) {
        this.getContainersService().deleteContainer(containerId);
    }

    @Override
    public String buildImage(ImageBuildConfiguration image) {
        byte[] bytes = RemoteApiBasedDockerProvider.getTgzArchiveForFiles(image);
        return this.miscService.buildImage(bytes, Optional.ofNullable(image.getNameAndTag()));
    }

    @Override
    public String commitContainer(ContainerCommitConfiguration configuration) {
        return this.miscService.commitContainer(configuration.getId(), Optional.ofNullable(configuration.getRepo()), Optional.ofNullable(configuration.getTag()), Optional.ofNullable(configuration.getComment()), Optional.ofNullable(configuration.getAuthor()));
    }

    @Override
    public void removeImage(String imageId) {
        this.getImagesService().deleteImage(imageId);
    }

    @Override
    public void pushImage(String nameAndTag) {
        this.getImagesService().pushImage(nameAndTag);
    }

    @Override
    public void tagImage(String imageId, String nameAndTag) {
        this.getImagesService().tagImage(imageId, nameAndTag);
    }

    public String toString() {
        return this.getClass().getName() + "{" + "host='" + this.host + '\'' + ", port=" + this.port + '}';
    }

    @Override
    public String getLogs(String containerId) {
        return this.containersService.getLogs(containerId);
    }

    @Override
    public void setLogger(Log logger) {
        this.log = logger;
    }

    protected RemoteApiBasedDockerProvider(String host, int port) {
        this.host = host;
        this.port = port;
        String dockerApiRoot = String.format("%s:%s", host, port);
        this.containersService = new ContainersService(dockerApiRoot);
        this.imagesService = new ImagesService(dockerApiRoot);
        this.miscService = new MiscService(dockerApiRoot);
        this.services = new HashSet<BaseService>();
        this.register(this.containersService, this.imagesService, this.miscService);
    }

    protected ContainerInspectionResult startContainer(ContainerStartConfiguration configuration, ContainerStartRequest startRequest) {
        String containerId;
        String imageId = configuration.getImage();
        ContainerCreateRequest createRequest = new ContainerCreateRequest().fromImage(imageId).withEnv(configuration.getEnv()).withHostname(configuration.getHostname());
        try {
            containerId = this.containersService.createContainer(createRequest);
        }
        catch (ImageNotFoundException e) {
            this.log.info((CharSequence)String.format("Pulling image %s...", imageId));
            this.imagesService.pullImage(imageId);
            containerId = this.containersService.createContainer(createRequest);
        }
        this.containersService.startContainer(containerId, startRequest);
        return this.containersService.inspectContainer(containerId);
    }

    protected ContainersService getContainersService() {
        return this.containersService;
    }

    protected ImagesService getImagesService() {
        return this.imagesService;
    }

    protected void register(BaseService ... servicesToBeRegistered) {
        Collections.addAll(this.services, servicesToBeRegistered);
    }

    protected String getHost() {
        return this.host;
    }

    protected int getPort() {
        return this.port;
    }

    private static byte[] getTgzArchiveForFiles(ImageBuildConfiguration image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ArchiveOutputStream tar = new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)baos);){
            RemoteApiBasedDockerProvider.addToTar(tar, image.getDockerFile(), "Dockerfile");
            if (image.getArtifacts() != null) {
                for (Artifact artifact : image.getArtifacts()) {
                    File file = artifact.getFile();
                    String pathinTar = artifact.getDest().orElse(file.getName());
                    RemoteApiBasedDockerProvider.addToTar(tar, file, pathinTar);
                }
            }
            tar.flush();
            baos.flush();
        }
        catch (IOException | ArchiveException e) {
            throw new IllegalStateException("Unable to create output archive", e);
        }
        return baos.toByteArray();
    }

    private static void addToTar(ArchiveOutputStream tar, File file, String fileNameAndPath) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new FileNotFoundException(String.format("Cannot read file %s. Are you sure it exists?", file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            for (File fileInDirectory : file.listFiles()) {
                if (!fileNameAndPath.endsWith("/")) {
                    fileNameAndPath = fileNameAndPath + "/";
                }
                RemoteApiBasedDockerProvider.addToTar(tar, fileInDirectory, fileNameAndPath + fileInDirectory.getName());
            }
        } else {
            ArchiveEntry entry = tar.createArchiveEntry(file, fileNameAndPath);
            tar.putArchiveEntry(entry);
            byte[] contents = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            tar.write(contents);
            tar.closeArchiveEntry();
        }
    }

    private static Integer getDockerPortFromEnvironment() {
        return ((Optional)DockerPortFromPropertySupplier.INSTANCE.get()).orElse(((Optional)DockerPortFromEnvironmentSupplier.INSTANCE.get()).orElse(2375));
    }

    private static String getDockerHostFromEnvironment() {
        return ((Optional)DockerHostFromPropertySupplier.INSTANCE.get()).orElse(((Optional)DockerHostFromEnvironmentSupplier.INSTANCE.get()).orElse(DEFAULT_DOCKER_HOST));
    }
}

