/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.provider.model;

import java.util.Optional;
import net.wouterdanes.docker.provider.model.ImageBuildConfiguration;

public class BuiltImageInfo {
    private final String startId;
    private final String imageId;
    private final Optional<String> registry;
    private final boolean keepAfterStopping;

    public BuiltImageInfo(String imageId, ImageBuildConfiguration imageConfig) {
        this.imageId = imageId;
        this.startId = imageConfig.getId();
        this.registry = Optional.ofNullable(imageConfig.getRegistry());
        this.keepAfterStopping = imageConfig.isKeep() || imageConfig.isPush();
    }

    public String getStartId() {
        return this.startId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public Optional<String> getRegistry() {
        return this.registry;
    }

    public boolean shouldKeepAfterStopping() {
        return this.keepAfterStopping;
    }
}

