/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.wouterdanes.docker.remoteapi.BaseService;
import net.wouterdanes.docker.remoteapi.exception.DockerException;
import net.wouterdanes.docker.remoteapi.model.ContainerCommitResponse;
import net.wouterdanes.docker.remoteapi.model.DockerVersionInfo;

public class MiscService
extends BaseService {
    private static final Pattern BUILD_IMAGE_ID_EXTRACTION_PATTERN = Pattern.compile(".*Successfully built ([0-9a-f]+).*", 32);

    public MiscService(String dockerApiRoot) {
        super(dockerApiRoot, "/");
    }

    public DockerVersionInfo getVersionInfo() {
        String json = (String)this.getServiceEndPoint().path("/version").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
        return this.toObject(json, DockerVersionInfo.class);
    }

    public String commitContainer(String container, Optional<String> repo, Optional<String> tag, Optional<String> comment, Optional<String> author) {
        WebTarget request = this.getServiceEndPoint().path("/commit").queryParam("container", new Object[]{container}).queryParam("repo", new Object[]{repo.orElse(null)}).queryParam("tag", new Object[]{tag.orElse(null)}).queryParam("comment", new Object[]{comment.orElse(null)}).queryParam("author", new Object[]{author.orElse(null)});
        String json = (String)request.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).method("POST", String.class);
        ContainerCommitResponse result = this.toObject(json, ContainerCommitResponse.class);
        return result.getId();
    }

    public String buildImage(byte[] tarArchive, Optional<String> name) {
        Response response = this.getServiceEndPoint().path("/build").queryParam("q", new Object[]{true}).queryParam("t", new Object[]{name.orElse(null)}).queryParam("forcerm", new Object[0]).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)tarArchive, (String)"application/tar"));
        InputStream inputStream = (InputStream)response.getEntity();
        String imageId = MiscService.parseSteamForImageId(inputStream);
        if (imageId == null) {
            throw new DockerException("Can't obtain ID from build output stream.");
        }
        return imageId;
    }

    private static String parseSteamForImageId(InputStream inputStream) {
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(isr);
        JsonStreamParser parser = new JsonStreamParser((Reader)reader);
        String imageId = null;
        while (parser.hasNext()) {
            JsonElement element = parser.next();
            JsonObject object = element.getAsJsonObject();
            if (object.has("stream")) {
                String text = object.get("stream").getAsString();
                System.out.print(text);
                Matcher matcher = BUILD_IMAGE_ID_EXTRACTION_PATTERN.matcher(text);
                if (matcher.matches()) {
                    imageId = matcher.group(1);
                }
            }
            if (object.has("status")) {
                System.out.println(object.get("status").getAsString());
            }
            if (!object.has("error")) continue;
            System.err.println("ERROR: " + object.get("error").getAsString());
        }
        return imageId;
    }
}

