/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class ContainerCreateRequest {
    @JsonProperty(value="Hostname")
    private String hostname;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="Memory")
    private Long memory;
    @JsonProperty(value="Cmd")
    private List<String> cmd;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Env")
    private List<String> env;

    public String getHostname() {
        return this.hostname;
    }

    public String getUser() {
        return this.user;
    }

    public Long getMemory() {
        return this.memory;
    }

    public List<String> getCmd() {
        return this.cmd;
    }

    public String getImage() {
        return this.image;
    }

    public List<String> getEnv() {
        return this.env != null ? Collections.unmodifiableList(this.env) : Collections.emptyList();
    }

    public ContainerCreateRequest withEnv(Map<String, String> env) {
        if (env != null && env.size() > 0) {
            this.env = new ArrayList<String>();
            for (Map.Entry<String, String> entry : env.entrySet()) {
                this.env.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        return this;
    }

    public ContainerCreateRequest withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public ContainerCreateRequest withUser(String user) {
        this.user = user;
        return this;
    }

    public ContainerCreateRequest withMemory(long memory) {
        this.memory = memory;
        return this;
    }

    public ContainerCreateRequest withCommand(String command) {
        this.cmd = Arrays.asList(command);
        return this;
    }

    public ContainerCreateRequest withCommands(List<String> commands) {
        this.cmd = new ArrayList<String>(commands);
        return this;
    }

    public ContainerCreateRequest fromImage(String image) {
        this.image = image;
        return this;
    }
}

