/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi.util;

import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import net.wouterdanes.docker.remoteapi.util.DockerEnvironmentSupplier;

public final class DockerPortFromEnvironmentSupplier
extends DockerEnvironmentSupplier
implements Supplier<Optional<Integer>> {
    public static final DockerPortFromEnvironmentSupplier INSTANCE = new DockerPortFromEnvironmentSupplier();

    private DockerPortFromEnvironmentSupplier() {
    }

    @Override
    public Optional<Integer> get() {
        Optional<URI> dockerUriFromEnvironment = this.getDockerUriFromEnvironment();
        if (!dockerUriFromEnvironment.isPresent()) {
            return Optional.empty();
        }
        URI dockerUrl = dockerUriFromEnvironment.get();
        boolean isTcpSocket = "tcp".equalsIgnoreCase(dockerUrl.getScheme());
        return isTcpSocket ? Optional.ofNullable(dockerUrl.getPort()) : Optional.empty();
    }
}

