/*
 * Decompiled with CFR 0.152.
 */
package net.xdow.aliyundrive.webapi.bean;

import com.google.gson.annotations.SerializedName;
import lombok.NonNull;
import net.xdow.aliyundrive.bean.AliyunDriveEnum;
import net.xdow.aliyundrive.webapi.bean.AliyunDriveWebShareRequestInfo;

public class AliyunDriveWebRequest {

    public static class DirectTransferSaveInfo
    extends AliyunDriveWebShareRequestInfo {
        @NonNull
        private String shareId;

        public DirectTransferSaveInfo(@NonNull String shareId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            this.shareId = shareId;
        }

        @NonNull
        public String getShareId() {
            return this.shareId;
        }

        public void setShareId(@NonNull String shareId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            this.shareId = shareId;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DirectTransferSaveInfo)) {
                return false;
            }
            DirectTransferSaveInfo other = (DirectTransferSaveInfo)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$shareId = this.getShareId();
            String other$shareId = other.getShareId();
            return !(this$shareId == null ? other$shareId != null : !this$shareId.equals(other$shareId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof DirectTransferSaveInfo;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $shareId = this.getShareId();
            result = result * 59 + ($shareId == null ? 43 : $shareId.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "AliyunDriveWebRequest.DirectTransferSaveInfo(shareId=" + this.getShareId() + ")";
        }
    }

    public static class ShareSaveInfo
    extends AliyunDriveWebShareRequestInfo {
        @NonNull
        private String shareId;
        @NonNull
        private String fileId;
        @NonNull
        private String toDriveId;
        @NonNull
        private String toParentFileId;
        private boolean autoRename = true;

        public ShareSaveInfo(@NonNull String shareId, @NonNull String fileId, @NonNull String toDriveId, @NonNull String toParentFileId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            if (toDriveId == null) {
                throw new NullPointerException("toDriveId is marked non-null but is null");
            }
            if (toParentFileId == null) {
                throw new NullPointerException("toParentFileId is marked non-null but is null");
            }
            this.shareId = shareId;
            this.fileId = fileId;
            this.toDriveId = toDriveId;
            this.toParentFileId = toParentFileId;
        }

        @NonNull
        public String getShareId() {
            return this.shareId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        @NonNull
        public String getToDriveId() {
            return this.toDriveId;
        }

        @NonNull
        public String getToParentFileId() {
            return this.toParentFileId;
        }

        public boolean isAutoRename() {
            return this.autoRename;
        }

        public void setShareId(@NonNull String shareId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            this.shareId = shareId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setToDriveId(@NonNull String toDriveId) {
            if (toDriveId == null) {
                throw new NullPointerException("toDriveId is marked non-null but is null");
            }
            this.toDriveId = toDriveId;
        }

        public void setToParentFileId(@NonNull String toParentFileId) {
            if (toParentFileId == null) {
                throw new NullPointerException("toParentFileId is marked non-null but is null");
            }
            this.toParentFileId = toParentFileId;
        }

        public void setAutoRename(boolean autoRename) {
            this.autoRename = autoRename;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShareSaveInfo)) {
                return false;
            }
            ShareSaveInfo other = (ShareSaveInfo)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isAutoRename() != other.isAutoRename()) {
                return false;
            }
            String this$shareId = this.getShareId();
            String other$shareId = other.getShareId();
            if (this$shareId == null ? other$shareId != null : !this$shareId.equals(other$shareId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$toDriveId = this.getToDriveId();
            String other$toDriveId = other.getToDriveId();
            if (this$toDriveId == null ? other$toDriveId != null : !this$toDriveId.equals(other$toDriveId)) {
                return false;
            }
            String this$toParentFileId = this.getToParentFileId();
            String other$toParentFileId = other.getToParentFileId();
            return !(this$toParentFileId == null ? other$toParentFileId != null : !this$toParentFileId.equals(other$toParentFileId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ShareSaveInfo;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAutoRename() ? 79 : 97);
            String $shareId = this.getShareId();
            result = result * 59 + ($shareId == null ? 43 : $shareId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $toDriveId = this.getToDriveId();
            result = result * 59 + ($toDriveId == null ? 43 : $toDriveId.hashCode());
            String $toParentFileId = this.getToParentFileId();
            result = result * 59 + ($toParentFileId == null ? 43 : $toParentFileId.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "AliyunDriveWebRequest.ShareSaveInfo(shareId=" + this.getShareId() + ", fileId=" + this.getFileId() + ", toDriveId=" + this.getToDriveId() + ", toParentFileId=" + this.getToParentFileId() + ", autoRename=" + this.isAutoRename() + ")";
        }
    }

    public static class DirectTransferGetFileInfo
    extends AliyunDriveWebShareRequestInfo {
        @NonNull
        private String shareId;
        private String fileId;
        private String category;
        @SerializedName(value="video_thumbnail_time")
        private Long videoThumbnailTimeMS;
        private Integer videoThumbnailWidth;
        private Integer imageThumbnailWidth;
        private String videoThumbnailProcess = "video/snapshot,t_1000,f_jpg,ar_auto,w_300";

        public void setThumbnailTimeMs(long time_ms) {
            this.setVideoThumbnailProcess("video/snapshot,t_" + time_ms + ",f_jpg,ar_auto,w_300");
        }

        public DirectTransferGetFileInfo(@NonNull String shareId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            this.shareId = shareId;
        }

        @NonNull
        public String getShareId() {
            return this.shareId;
        }

        public String getFileId() {
            return this.fileId;
        }

        public String getCategory() {
            return this.category;
        }

        public Long getVideoThumbnailTimeMS() {
            return this.videoThumbnailTimeMS;
        }

        public Integer getVideoThumbnailWidth() {
            return this.videoThumbnailWidth;
        }

        public Integer getImageThumbnailWidth() {
            return this.imageThumbnailWidth;
        }

        public String getVideoThumbnailProcess() {
            return this.videoThumbnailProcess;
        }

        public void setShareId(@NonNull String shareId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            this.shareId = shareId;
        }

        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public void setVideoThumbnailTimeMS(Long videoThumbnailTimeMS) {
            this.videoThumbnailTimeMS = videoThumbnailTimeMS;
        }

        public void setVideoThumbnailWidth(Integer videoThumbnailWidth) {
            this.videoThumbnailWidth = videoThumbnailWidth;
        }

        public void setImageThumbnailWidth(Integer imageThumbnailWidth) {
            this.imageThumbnailWidth = imageThumbnailWidth;
        }

        public void setVideoThumbnailProcess(String videoThumbnailProcess) {
            this.videoThumbnailProcess = videoThumbnailProcess;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DirectTransferGetFileInfo)) {
                return false;
            }
            DirectTransferGetFileInfo other = (DirectTransferGetFileInfo)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Long this$videoThumbnailTimeMS = this.getVideoThumbnailTimeMS();
            Long other$videoThumbnailTimeMS = other.getVideoThumbnailTimeMS();
            if (this$videoThumbnailTimeMS == null ? other$videoThumbnailTimeMS != null : !((Object)this$videoThumbnailTimeMS).equals(other$videoThumbnailTimeMS)) {
                return false;
            }
            Integer this$videoThumbnailWidth = this.getVideoThumbnailWidth();
            Integer other$videoThumbnailWidth = other.getVideoThumbnailWidth();
            if (this$videoThumbnailWidth == null ? other$videoThumbnailWidth != null : !((Object)this$videoThumbnailWidth).equals(other$videoThumbnailWidth)) {
                return false;
            }
            Integer this$imageThumbnailWidth = this.getImageThumbnailWidth();
            Integer other$imageThumbnailWidth = other.getImageThumbnailWidth();
            if (this$imageThumbnailWidth == null ? other$imageThumbnailWidth != null : !((Object)this$imageThumbnailWidth).equals(other$imageThumbnailWidth)) {
                return false;
            }
            String this$shareId = this.getShareId();
            String other$shareId = other.getShareId();
            if (this$shareId == null ? other$shareId != null : !this$shareId.equals(other$shareId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$videoThumbnailProcess = this.getVideoThumbnailProcess();
            String other$videoThumbnailProcess = other.getVideoThumbnailProcess();
            return !(this$videoThumbnailProcess == null ? other$videoThumbnailProcess != null : !this$videoThumbnailProcess.equals(other$videoThumbnailProcess));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof DirectTransferGetFileInfo;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $videoThumbnailTimeMS = this.getVideoThumbnailTimeMS();
            result = result * 59 + ($videoThumbnailTimeMS == null ? 43 : ((Object)$videoThumbnailTimeMS).hashCode());
            Integer $videoThumbnailWidth = this.getVideoThumbnailWidth();
            result = result * 59 + ($videoThumbnailWidth == null ? 43 : ((Object)$videoThumbnailWidth).hashCode());
            Integer $imageThumbnailWidth = this.getImageThumbnailWidth();
            result = result * 59 + ($imageThumbnailWidth == null ? 43 : ((Object)$imageThumbnailWidth).hashCode());
            String $shareId = this.getShareId();
            result = result * 59 + ($shareId == null ? 43 : $shareId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $videoThumbnailProcess = this.getVideoThumbnailProcess();
            result = result * 59 + ($videoThumbnailProcess == null ? 43 : $videoThumbnailProcess.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "AliyunDriveWebRequest.DirectTransferGetFileInfo(shareId=" + this.getShareId() + ", fileId=" + this.getFileId() + ", category=" + this.getCategory() + ", videoThumbnailTimeMS=" + this.getVideoThumbnailTimeMS() + ", videoThumbnailWidth=" + this.getVideoThumbnailWidth() + ", imageThumbnailWidth=" + this.getImageThumbnailWidth() + ", videoThumbnailProcess=" + this.getVideoThumbnailProcess() + ")";
        }
    }

    public static class ShareGetFileInfo
    extends AliyunDriveWebShareRequestInfo {
        @NonNull
        private String shareId;
        @NonNull
        private String fileId;
        private String category;
        @SerializedName(value="video_thumbnail_time")
        private Long videoThumbnailTimeMS;
        private Integer videoThumbnailWidth;
        private Integer imageThumbnailWidth;
        private String videoThumbnailProcess = "video/snapshot,t_1000,f_jpg,ar_auto,w_300";

        public void setThumbnailTimeMs(long time_ms) {
            this.setVideoThumbnailProcess("video/snapshot,t_" + time_ms + ",f_jpg,ar_auto,w_300");
        }

        public ShareGetFileInfo(@NonNull String shareId, @NonNull String fileId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.shareId = shareId;
            this.fileId = fileId;
        }

        @NonNull
        public String getShareId() {
            return this.shareId;
        }

        @NonNull
        public String getFileId() {
            return this.fileId;
        }

        public String getCategory() {
            return this.category;
        }

        public Long getVideoThumbnailTimeMS() {
            return this.videoThumbnailTimeMS;
        }

        public Integer getVideoThumbnailWidth() {
            return this.videoThumbnailWidth;
        }

        public Integer getImageThumbnailWidth() {
            return this.imageThumbnailWidth;
        }

        public String getVideoThumbnailProcess() {
            return this.videoThumbnailProcess;
        }

        public void setShareId(@NonNull String shareId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            this.shareId = shareId;
        }

        public void setFileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public void setVideoThumbnailTimeMS(Long videoThumbnailTimeMS) {
            this.videoThumbnailTimeMS = videoThumbnailTimeMS;
        }

        public void setVideoThumbnailWidth(Integer videoThumbnailWidth) {
            this.videoThumbnailWidth = videoThumbnailWidth;
        }

        public void setImageThumbnailWidth(Integer imageThumbnailWidth) {
            this.imageThumbnailWidth = imageThumbnailWidth;
        }

        public void setVideoThumbnailProcess(String videoThumbnailProcess) {
            this.videoThumbnailProcess = videoThumbnailProcess;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShareGetFileInfo)) {
                return false;
            }
            ShareGetFileInfo other = (ShareGetFileInfo)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Long this$videoThumbnailTimeMS = this.getVideoThumbnailTimeMS();
            Long other$videoThumbnailTimeMS = other.getVideoThumbnailTimeMS();
            if (this$videoThumbnailTimeMS == null ? other$videoThumbnailTimeMS != null : !((Object)this$videoThumbnailTimeMS).equals(other$videoThumbnailTimeMS)) {
                return false;
            }
            Integer this$videoThumbnailWidth = this.getVideoThumbnailWidth();
            Integer other$videoThumbnailWidth = other.getVideoThumbnailWidth();
            if (this$videoThumbnailWidth == null ? other$videoThumbnailWidth != null : !((Object)this$videoThumbnailWidth).equals(other$videoThumbnailWidth)) {
                return false;
            }
            Integer this$imageThumbnailWidth = this.getImageThumbnailWidth();
            Integer other$imageThumbnailWidth = other.getImageThumbnailWidth();
            if (this$imageThumbnailWidth == null ? other$imageThumbnailWidth != null : !((Object)this$imageThumbnailWidth).equals(other$imageThumbnailWidth)) {
                return false;
            }
            String this$shareId = this.getShareId();
            String other$shareId = other.getShareId();
            if (this$shareId == null ? other$shareId != null : !this$shareId.equals(other$shareId)) {
                return false;
            }
            String this$fileId = this.getFileId();
            String other$fileId = other.getFileId();
            if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$videoThumbnailProcess = this.getVideoThumbnailProcess();
            String other$videoThumbnailProcess = other.getVideoThumbnailProcess();
            return !(this$videoThumbnailProcess == null ? other$videoThumbnailProcess != null : !this$videoThumbnailProcess.equals(other$videoThumbnailProcess));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ShareGetFileInfo;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $videoThumbnailTimeMS = this.getVideoThumbnailTimeMS();
            result = result * 59 + ($videoThumbnailTimeMS == null ? 43 : ((Object)$videoThumbnailTimeMS).hashCode());
            Integer $videoThumbnailWidth = this.getVideoThumbnailWidth();
            result = result * 59 + ($videoThumbnailWidth == null ? 43 : ((Object)$videoThumbnailWidth).hashCode());
            Integer $imageThumbnailWidth = this.getImageThumbnailWidth();
            result = result * 59 + ($imageThumbnailWidth == null ? 43 : ((Object)$imageThumbnailWidth).hashCode());
            String $shareId = this.getShareId();
            result = result * 59 + ($shareId == null ? 43 : $shareId.hashCode());
            String $fileId = this.getFileId();
            result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $videoThumbnailProcess = this.getVideoThumbnailProcess();
            result = result * 59 + ($videoThumbnailProcess == null ? 43 : $videoThumbnailProcess.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "AliyunDriveWebRequest.ShareGetFileInfo(shareId=" + this.getShareId() + ", fileId=" + this.getFileId() + ", category=" + this.getCategory() + ", videoThumbnailTimeMS=" + this.getVideoThumbnailTimeMS() + ", videoThumbnailWidth=" + this.getVideoThumbnailWidth() + ", imageThumbnailWidth=" + this.getImageThumbnailWidth() + ", videoThumbnailProcess=" + this.getVideoThumbnailProcess() + ")";
        }
    }

    public static class ShareListInfo
    extends AliyunDriveWebShareRequestInfo {
        @NonNull
        private String shareId;
        private int limit = 100;
        private String marker;
        private AliyunDriveEnum.OrderBy orderBy;
        private AliyunDriveEnum.OrderDirection orderDirection;
        @NonNull
        private String parentFileId;
        private AliyunDriveEnum.Category category;
        @SerializedName(value="video_thumbnail_time")
        private Integer videoThumbnailTimeMS;
        private Integer videoThumbnailWidth;
        private Integer imageThumbnailWidth;
        private String fields = "*";

        public ShareListInfo(@NonNull String shareId, @NonNull String parentFileId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            if (parentFileId == null) {
                throw new NullPointerException("parentFileId is marked non-null but is null");
            }
            this.shareId = shareId;
            this.parentFileId = parentFileId;
        }

        @NonNull
        public String getShareId() {
            return this.shareId;
        }

        public int getLimit() {
            return this.limit;
        }

        public String getMarker() {
            return this.marker;
        }

        public AliyunDriveEnum.OrderBy getOrderBy() {
            return this.orderBy;
        }

        public AliyunDriveEnum.OrderDirection getOrderDirection() {
            return this.orderDirection;
        }

        @NonNull
        public String getParentFileId() {
            return this.parentFileId;
        }

        public AliyunDriveEnum.Category getCategory() {
            return this.category;
        }

        public Integer getVideoThumbnailTimeMS() {
            return this.videoThumbnailTimeMS;
        }

        public Integer getVideoThumbnailWidth() {
            return this.videoThumbnailWidth;
        }

        public Integer getImageThumbnailWidth() {
            return this.imageThumbnailWidth;
        }

        public String getFields() {
            return this.fields;
        }

        public void setShareId(@NonNull String shareId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            this.shareId = shareId;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public void setMarker(String marker) {
            this.marker = marker;
        }

        public void setOrderBy(AliyunDriveEnum.OrderBy orderBy) {
            this.orderBy = orderBy;
        }

        public void setOrderDirection(AliyunDriveEnum.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
        }

        public void setParentFileId(@NonNull String parentFileId) {
            if (parentFileId == null) {
                throw new NullPointerException("parentFileId is marked non-null but is null");
            }
            this.parentFileId = parentFileId;
        }

        public void setCategory(AliyunDriveEnum.Category category) {
            this.category = category;
        }

        public void setVideoThumbnailTimeMS(Integer videoThumbnailTimeMS) {
            this.videoThumbnailTimeMS = videoThumbnailTimeMS;
        }

        public void setVideoThumbnailWidth(Integer videoThumbnailWidth) {
            this.videoThumbnailWidth = videoThumbnailWidth;
        }

        public void setImageThumbnailWidth(Integer imageThumbnailWidth) {
            this.imageThumbnailWidth = imageThumbnailWidth;
        }

        public void setFields(String fields) {
            this.fields = fields;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShareListInfo)) {
                return false;
            }
            ShareListInfo other = (ShareListInfo)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            Integer this$videoThumbnailTimeMS = this.getVideoThumbnailTimeMS();
            Integer other$videoThumbnailTimeMS = other.getVideoThumbnailTimeMS();
            if (this$videoThumbnailTimeMS == null ? other$videoThumbnailTimeMS != null : !((Object)this$videoThumbnailTimeMS).equals(other$videoThumbnailTimeMS)) {
                return false;
            }
            Integer this$videoThumbnailWidth = this.getVideoThumbnailWidth();
            Integer other$videoThumbnailWidth = other.getVideoThumbnailWidth();
            if (this$videoThumbnailWidth == null ? other$videoThumbnailWidth != null : !((Object)this$videoThumbnailWidth).equals(other$videoThumbnailWidth)) {
                return false;
            }
            Integer this$imageThumbnailWidth = this.getImageThumbnailWidth();
            Integer other$imageThumbnailWidth = other.getImageThumbnailWidth();
            if (this$imageThumbnailWidth == null ? other$imageThumbnailWidth != null : !((Object)this$imageThumbnailWidth).equals(other$imageThumbnailWidth)) {
                return false;
            }
            String this$shareId = this.getShareId();
            String other$shareId = other.getShareId();
            if (this$shareId == null ? other$shareId != null : !this$shareId.equals(other$shareId)) {
                return false;
            }
            String this$marker = this.getMarker();
            String other$marker = other.getMarker();
            if (this$marker == null ? other$marker != null : !this$marker.equals(other$marker)) {
                return false;
            }
            AliyunDriveEnum.OrderBy this$orderBy = this.getOrderBy();
            AliyunDriveEnum.OrderBy other$orderBy = other.getOrderBy();
            if (this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy)) {
                return false;
            }
            AliyunDriveEnum.OrderDirection this$orderDirection = this.getOrderDirection();
            AliyunDriveEnum.OrderDirection other$orderDirection = other.getOrderDirection();
            if (this$orderDirection == null ? other$orderDirection != null : !this$orderDirection.equals(other$orderDirection)) {
                return false;
            }
            String this$parentFileId = this.getParentFileId();
            String other$parentFileId = other.getParentFileId();
            if (this$parentFileId == null ? other$parentFileId != null : !this$parentFileId.equals(other$parentFileId)) {
                return false;
            }
            AliyunDriveEnum.Category this$category = this.getCategory();
            AliyunDriveEnum.Category other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$fields = this.getFields();
            String other$fields = other.getFields();
            return !(this$fields == null ? other$fields != null : !this$fields.equals(other$fields));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ShareListInfo;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLimit();
            Integer $videoThumbnailTimeMS = this.getVideoThumbnailTimeMS();
            result = result * 59 + ($videoThumbnailTimeMS == null ? 43 : ((Object)$videoThumbnailTimeMS).hashCode());
            Integer $videoThumbnailWidth = this.getVideoThumbnailWidth();
            result = result * 59 + ($videoThumbnailWidth == null ? 43 : ((Object)$videoThumbnailWidth).hashCode());
            Integer $imageThumbnailWidth = this.getImageThumbnailWidth();
            result = result * 59 + ($imageThumbnailWidth == null ? 43 : ((Object)$imageThumbnailWidth).hashCode());
            String $shareId = this.getShareId();
            result = result * 59 + ($shareId == null ? 43 : $shareId.hashCode());
            String $marker = this.getMarker();
            result = result * 59 + ($marker == null ? 43 : $marker.hashCode());
            AliyunDriveEnum.OrderBy $orderBy = this.getOrderBy();
            result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
            AliyunDriveEnum.OrderDirection $orderDirection = this.getOrderDirection();
            result = result * 59 + ($orderDirection == null ? 43 : $orderDirection.hashCode());
            String $parentFileId = this.getParentFileId();
            result = result * 59 + ($parentFileId == null ? 43 : $parentFileId.hashCode());
            AliyunDriveEnum.Category $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "AliyunDriveWebRequest.ShareListInfo(shareId=" + this.getShareId() + ", limit=" + this.getLimit() + ", marker=" + this.getMarker() + ", orderBy=" + this.getOrderBy() + ", orderDirection=" + this.getOrderDirection() + ", parentFileId=" + this.getParentFileId() + ", category=" + this.getCategory() + ", videoThumbnailTimeMS=" + this.getVideoThumbnailTimeMS() + ", videoThumbnailWidth=" + this.getVideoThumbnailWidth() + ", imageThumbnailWidth=" + this.getImageThumbnailWidth() + ", fields=" + this.getFields() + ")";
        }
    }

    public static class ShareTokenInfo {
        @NonNull
        private String shareId;
        @SerializedName(value="share_pwd")
        @NonNull
        private String sharePassword;

        public ShareTokenInfo(@NonNull String shareId, @NonNull String sharePassword) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            if (sharePassword == null) {
                throw new NullPointerException("sharePassword is marked non-null but is null");
            }
            this.shareId = shareId;
            this.sharePassword = sharePassword;
        }

        @NonNull
        public String getShareId() {
            return this.shareId;
        }

        @NonNull
        public String getSharePassword() {
            return this.sharePassword;
        }

        public void setShareId(@NonNull String shareId) {
            if (shareId == null) {
                throw new NullPointerException("shareId is marked non-null but is null");
            }
            this.shareId = shareId;
        }

        public void setSharePassword(@NonNull String sharePassword) {
            if (sharePassword == null) {
                throw new NullPointerException("sharePassword is marked non-null but is null");
            }
            this.sharePassword = sharePassword;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShareTokenInfo)) {
                return false;
            }
            ShareTokenInfo other = (ShareTokenInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$shareId = this.getShareId();
            String other$shareId = other.getShareId();
            if (this$shareId == null ? other$shareId != null : !this$shareId.equals(other$shareId)) {
                return false;
            }
            String this$sharePassword = this.getSharePassword();
            String other$sharePassword = other.getSharePassword();
            return !(this$sharePassword == null ? other$sharePassword != null : !this$sharePassword.equals(other$sharePassword));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ShareTokenInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $shareId = this.getShareId();
            result = result * 59 + ($shareId == null ? 43 : $shareId.hashCode());
            String $sharePassword = this.getSharePassword();
            result = result * 59 + ($sharePassword == null ? 43 : $sharePassword.hashCode());
            return result;
        }

        public String toString() {
            return "AliyunDriveWebRequest.ShareTokenInfo(shareId=" + this.getShareId() + ", sharePassword=" + this.getSharePassword() + ")";
        }
    }
}

