/*
 * Decompiled with CFR 0.152.
 */
package net.xdow.aliyundrive.webapi.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.xdow.aliyundrive.IAliyunDrive;
import net.xdow.aliyundrive.IAliyunDriveAuthorizer;
import net.xdow.aliyundrive.bean.AliyunDriveEnum;
import net.xdow.aliyundrive.bean.AliyunDriveFileInfo;
import net.xdow.aliyundrive.bean.AliyunDriveRequest;
import net.xdow.aliyundrive.bean.AliyunDriveResponse;
import net.xdow.aliyundrive.net.AliyunDriveCall;
import net.xdow.aliyundrive.net.interceptor.AccessTokenInvalidInterceptor;
import net.xdow.aliyundrive.net.interceptor.AliyunDriveAuthenticateInterceptor;
import net.xdow.aliyundrive.net.interceptor.XHttpLoggingInterceptor;
import net.xdow.aliyundrive.util.JsonUtils;
import net.xdow.aliyundrive.util.StringUtils;
import net.xdow.aliyundrive.webapi.AliyunDriveWebConstant;
import net.xdow.aliyundrive.webapi.bean.AliyunDriveWebRequest;
import net.xdow.aliyundrive.webapi.bean.AliyunDriveWebResponse;
import net.xdow.aliyundrive.webapi.bean.AliyunDriveWebShareRequestInfo;
import net.xdow.aliyundrive.webapi.net.AliyunDriveWebCall;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.Route;
import okhttp3.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

public class AliyunDriveWebApiImplV1
implements IAliyunDrive,
AliyunDriveAuthenticateInterceptor.IAccessTokenInfoGetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunDriveWebApiImplV1.class);
    private OkHttpClient mOkHttpClient;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private AliyunDriveResponse.AccessTokenInfo mAccessTokenInfo;
    private IAliyunDriveAuthorizer mAliyunDriveAuthorizer;
    private AccessTokenInvalidInterceptor mAccessTokenInvalidInterceptor = new AccessTokenInvalidInterceptor();

    public AliyunDriveWebApiImplV1() {
        this.initOkHttp();
    }

    private void initOkHttp() {
        XHttpLoggingInterceptor loggingInterceptor = new XHttpLoggingInterceptor();
        AliyunDriveAuthenticateInterceptor authenticateInterceptor = new AliyunDriveAuthenticateInterceptor((AliyunDriveAuthenticateInterceptor.IAccessTokenInfoGetter)this);
        this.mOkHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)loggingInterceptor).addInterceptor((Interceptor)authenticateInterceptor).addInterceptor((Interceptor)this.mAccessTokenInvalidInterceptor).addInterceptor(new Interceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response response;
                block13: {
                    Request request = chain.request();
                    response = chain.proceed(AliyunDriveWebApiImplV1.this.buildCommonRequestHeader(request));
                    int code = response.code();
                    if (code == 400 || code == 401) {
                        ResponseBody body = response.peekBody(40960L);
                        try {
                            String res = body.string();
                            String url = request.url().toString();
                            boolean isRenewRequest = url.endsWith("/renew_session");
                            if (!isRenewRequest && res.contains("DeviceSessionSignatureInvalid")) {
                                AliyunDriveWebApiImplV1.this.onAuthorizerEvent("Web.DeviceSessionSignatureInvalid");
                                Response response2 = chain.proceed(AliyunDriveWebApiImplV1.this.buildCommonRequestHeader(request));
                                return response2;
                            }
                            if (isRenewRequest || !res.contains("UserDeviceOffline")) break block13;
                            AliyunDriveWebApiImplV1.this.onAuthorizerEvent("Web.UserDeviceOffline");
                            LOGGER.error("\u767b\u5f55\u8bbe\u5907\u8fc7\u591a, \u8bf7\u8fdb\u5165\"\u767b\u5f55\u8bbe\u5907\u7ba1\u7406\", \u9000\u51fa\u4e00\u4e9b\u8bbe\u5907, \u5982\u8bbe\u5907\u88ab\u610f\u5916\u9000\u51fa\u767b\u5f55, \u8bf7\u624b\u52a8\u5220\u9664\u914d\u7f6e\u6587\u4ef6\u540e\u91cd\u542f\u7a0b\u5e8f\u3002");
                            if (!url.endsWith("/token/refresh")) {
                                AliyunDriveWebApiImplV1.this.requestNewAccessToken();
                                Response retryResponse = chain.proceed(AliyunDriveWebApiImplV1.this.buildCommonRequestHeader(request));
                                ResponseBody retryBody = response.peekBody(40960L);
                                try {
                                    String retryRes = retryBody.string();
                                    if (retryRes.contains("UserDeviceOffline")) {
                                        LOGGER.error("\u91cd\u65b0\u767b\u5f55\u5931\u8d25, \u8bbe\u5907\u6570\u8fc7\u591a, \u7b49\u5f8530\u5206\u949f...");
                                        try {
                                            TimeUnit.MINUTES.sleep(30L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                finally {
                                    Util.closeQuietly((Closeable)retryBody);
                                }
                            }
                            Response response3 = response;
                            return response3;
                        }
                        finally {
                            Util.closeQuietly((Closeable)body);
                        }
                    }
                }
                return response;
            }
        }).authenticator(new Authenticator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Request authenticate(Route route, Response response) throws IOException {
                int code = response.code();
                if (code == 401 || code == 400) {
                    ResponseBody body = response.peekBody(40960L);
                    try {
                        String res = body.string();
                        if (res.contains("AccessToken")) {
                            AliyunDriveWebApiImplV1.this.requestNewAccessToken();
                            String accessToken = AliyunDriveWebApiImplV1.this.mAccessTokenInfo.getAccessToken();
                            Request request = response.request().newBuilder().removeHeader("authorization").header("authorization", accessToken).build();
                            return request;
                        }
                    }
                    finally {
                        Util.closeQuietly((Closeable)body);
                    }
                }
                return null;
            }
        }).readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).connectTimeout(1L, TimeUnit.MINUTES).dns(new Dns(){

            public List<InetAddress> lookup(String hostname) throws UnknownHostException {
                UnknownHostException unknownHostException;
                ArrayList<InetAddress> list;
                block5: {
                    list = new ArrayList<InetAddress>();
                    unknownHostException = null;
                    try {
                        list.addAll(Dns.SYSTEM.lookup(hostname));
                    }
                    catch (UnknownHostException e) {
                        unknownHostException = e;
                    }
                    try {
                        list.addAll(Arrays.asList(Address.getAllByName((String)hostname)));
                    }
                    catch (UnknownHostException e) {
                        if (unknownHostException != null) break block5;
                        unknownHostException = e;
                    }
                }
                if (list.size() <= 0 && unknownHostException != null) {
                    throw unknownHostException;
                }
                return list;
            }
        }).followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(true).build();
    }

    public String post(String url, Object body) {
        String bodyAsJson = JsonUtils.toJson((Object)body);
        Request.Builder requestBuilder = new Request.Builder().post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)bodyAsJson)).addHeader("x-authenticate!!", "1").url(url);
        Request request = requestBuilder.build();
        String res = "";
        try {
            Response response = this.mOkHttpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                try {
                    res = response.body().string();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (res.contains("refresh_token is not valid")) {
                    this.onAuthorizerEvent("Web.RefreshTokenInvalid");
                }
                LOGGER.error("\u8bf7\u6c42\u5931\u8d25 post {}, body {}, code {} res {}", new Object[]{url, bodyAsJson, response.code(), res});
                return res;
            }
            res = response.body().string();
            LOGGER.info("post {}, body {}, code {} res {}", new Object[]{url, bodyAsJson, response.code(), res});
            return res;
        }
        catch (Exception e) {
            LOGGER.error("post fail", (Throwable)e);
            return "{ \"code\": \"NetworkError\", \"message\":\"Network error.\"}";
        }
    }

    public void setAccessTokenInfo(AliyunDriveResponse.AccessTokenInfo info) {
        this.mAccessTokenInfo = info;
    }

    public void setAuthorizer(IAliyunDriveAuthorizer authorizer) {
        this.mAliyunDriveAuthorizer = authorizer;
    }

    public void setAccessTokenInvalidListener(Runnable listener) {
        this.mAccessTokenInvalidInterceptor.setAccessTokenInvalidListener(listener);
    }

    private void onAuthorizerEvent(String eventId) {
        this.onAuthorizerEvent(eventId, null, null);
    }

    private <T> T onAuthorizerEvent(String eventId, Class<T> resultCls) {
        return this.onAuthorizerEvent(eventId, null, resultCls);
    }

    private <T> T onAuthorizerEvent(String eventId, Object data, Class<T> resultCls) {
        IAliyunDriveAuthorizer authorizer = this.mAliyunDriveAuthorizer;
        if (authorizer == null) {
            return null;
        }
        return (T)authorizer.onAuthorizerEvent(eventId, data, resultCls);
    }

    private void requestNewAccessToken() {
        IAliyunDriveAuthorizer authorizer = this.mAliyunDriveAuthorizer;
        if (authorizer == null) {
            return;
        }
        try {
            AliyunDriveResponse.AccessTokenInfo newAccessTokenInfo = authorizer.acquireNewAccessToken(this.mAccessTokenInfo);
            if (newAccessTokenInfo != null) {
                this.mAccessTokenInfo = newAccessTokenInfo;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    private Request buildCommonRequestHeader(Request request) {
        Request.Builder builder = request.newBuilder();
        Map<String, String> map = this.getCommonHeaders();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            builder.removeHeader(key);
            builder.addHeader(key, value);
        }
        return builder.build();
    }

    public AliyunDriveCall<AliyunDriveResponse.AccessTokenInfo> getAccessToken(String url) {
        return new AliyunDriveWebCall<AliyunDriveResponse.AccessTokenInfo>(this.mAccessTokenInfo);
    }

    public AliyunDriveCall<AliyunDriveResponse.QrCodeGenerateInfo> qrCodeGenerate(String url) {
        throw new UnsupportedOperationException();
    }

    public AliyunDriveCall<AliyunDriveResponse.QrCodeQueryStatusInfo> qrCodeQueryStatus(String sid) {
        throw new UnsupportedOperationException();
    }

    public String qrCodeImageUrl(String sid) {
        throw new UnsupportedOperationException();
    }

    public AliyunDriveCall<AliyunDriveResponse.AccessTokenInfo> getAccessToken(AliyunDriveRequest.AccessTokenInfo query) {
        if (query.getGrantType() != AliyunDriveEnum.GrantType.RefreshToken) {
            throw new UnsupportedOperationException("getAccessToken grant_type must be refresh_token, got: " + query.getGrantType().name());
        }
        Map<String, String> params = Collections.singletonMap("refresh_token", query.getRefreshToken());
        return this.postApiRequest("https://api.aliyundrive.com/token/refresh", params, AliyunDriveResponse.AccessTokenInfo.class, 1).mockResultOnSuccess((AliyunDriveCall.MockResultCallback)new AliyunDriveCall.MockResultCallback<AliyunDriveResponse.AccessTokenInfo>(){

            public AliyunDriveResponse.AccessTokenInfo onSuccess(AliyunDriveResponse.AccessTokenInfo res) {
                if (StringUtils.isEmpty((String)res.getTokenType())) {
                    res.setTokenType("Bearer");
                }
                if (StringUtils.isEmpty((String)res.getExpiresIn())) {
                    res.setExpiresIn("7200");
                }
                return res;
            }
        });
    }

    public AliyunDriveCall<AliyunDriveResponse.QrCodeGenerateInfo> qrCodeGenerate(AliyunDriveRequest.QrCodeGenerateInfo query) {
        throw new UnsupportedOperationException();
    }

    public AliyunDriveCall<AliyunDriveResponse.FileListInfo> fileList(AliyunDriveRequest.FileListInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/list", query, AliyunDriveResponse.FileListInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.UserSpaceInfo> getUserSpaceInfo() {
        return this.postApiRequest("https://api.aliyundrive.com/adrive/v1/user/driveCapacityDetails", AliyunDriveWebResponse.UserSpaceInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.UserDriveInfo> getUserDriveInfo() {
        return this.postApiRequest("https://user.aliyundrive.com/v2/user/get", AliyunDriveResponse.UserDriveInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileGetInfo> fileGet(AliyunDriveRequest.FileGetInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/get", query, AliyunDriveResponse.FileGetInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileGetInfo> fileGetByPath(AliyunDriveRequest.FileGetByPathInfo query) {
        return null;
    }

    public AliyunDriveCall<AliyunDriveResponse.FileBatchGetInfo> fileBatchGet(AliyunDriveRequest.FileBatchGetInfo query) {
        List fileList = query.getFileList();
        ArrayList<AliyunDriveResponse.FileGetInfo> items = new ArrayList<AliyunDriveResponse.FileGetInfo>();
        for (AliyunDriveRequest.FileBatchGetInfo.FileInfo fileInfo : fileList) {
            AliyunDriveRequest.FileGetInfo fileGetQuery = new AliyunDriveRequest.FileGetInfo(fileInfo.getDriveId(), fileInfo.getFileId());
            AliyunDriveResponse.FileGetInfo fileGetRes = (AliyunDriveResponse.FileGetInfo)this.fileGet(fileGetQuery).execute();
            items.add(fileGetRes);
        }
        AliyunDriveResponse.FileBatchGetInfo res = new AliyunDriveResponse.FileBatchGetInfo();
        res.setItems(items);
        return new AliyunDriveWebCall<AliyunDriveResponse.FileBatchGetInfo>(res);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileGetDownloadUrlInfo> fileGetDownloadUrl(AliyunDriveRequest.FileGetDownloadUrlInfo query) {
        int expireSec = query.getExpireSec();
        if (expireSec < 900 || expireSec > 115200) {
            throw new IllegalArgumentException("Error: expire_sec argument must between 900-115200s, got: " + expireSec);
        }
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/get_download_url", query, AliyunDriveResponse.FileGetDownloadUrlInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileCreateInfo> fileCreate(AliyunDriveRequest.FileCreateInfo query) {
        int partInfoListSize;
        List partInfoList = query.getPartInfoList();
        if (partInfoList != null && (partInfoListSize = partInfoList.size()) > 10000) {
            throw new IllegalArgumentException("Error: max part_info_list size must < 10000, got: " + partInfoListSize);
        }
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/create_with_proof", query, AliyunDriveResponse.FileCreateInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileGetUploadUrlInfo> fileGetUploadUrl(AliyunDriveRequest.FileGetUploadUrlInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/get_upload_url", query, AliyunDriveResponse.FileGetUploadUrlInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileListUploadPartsInfo> fileListUploadedParts(AliyunDriveRequest.FileListUploadPartsInfo query) {
        throw new UnsupportedOperationException();
    }

    public AliyunDriveCall<AliyunDriveResponse.FileUploadCompleteInfo> fileUploadComplete(AliyunDriveRequest.FileUploadCompleteInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/complete", query, AliyunDriveResponse.FileUploadCompleteInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileRenameInfo> fileRename(AliyunDriveRequest.FileRenameInfo query) {
        AliyunDriveRequest.FileCreateInfo createQuery = new AliyunDriveRequest.FileCreateInfo(query.getDriveId(), query.getParentFileId(), query.getName(), AliyunDriveEnum.Type.File, AliyunDriveEnum.CheckNameMode.Refuse);
        AliyunDriveResponse.FileCreateInfo createRes = (AliyunDriveResponse.FileCreateInfo)this.fileCreate(createQuery).execute();
        String createdFileId = createRes.getFileId();
        if (!StringUtils.isEmpty((String)createdFileId)) {
            AliyunDriveRequest.FileDeleteInfo deleteQuery = new AliyunDriveRequest.FileDeleteInfo(query.getDriveId(), createdFileId);
            this.fileDelete(deleteQuery).execute();
        }
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/update", query, AliyunDriveResponse.FileRenameInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileMoveInfo> fileMove(AliyunDriveRequest.FileMoveInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/move", query, AliyunDriveResponse.FileMoveInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileCopyInfo> fileCopy(AliyunDriveRequest.FileCopyInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/copy", query, AliyunDriveResponse.FileCopyInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileMoveToTrashInfo> fileMoveToTrash(final AliyunDriveRequest.FileMoveToTrashInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/recyclebin/trash", query, AliyunDriveResponse.FileMoveToTrashInfo.class, 2).mockResultOnSuccess((AliyunDriveCall.MockResultCallback)new AliyunDriveCall.MockResultCallback<AliyunDriveResponse.FileMoveToTrashInfo>(){

            public AliyunDriveResponse.FileMoveToTrashInfo onSuccess(AliyunDriveResponse.FileMoveToTrashInfo res) {
                if (res == null) {
                    res = new AliyunDriveResponse.FileMoveToTrashInfo();
                    res.setFileId(query.getFileId());
                    res.setDriveId(query.getDriveId());
                    res.setAsyncTaskId("");
                }
                return res;
            }
        });
    }

    public AliyunDriveCall<AliyunDriveResponse.GenericMessageInfo> fileRestoreFromTrash(AliyunDriveRequest.FileRestoreFromTrashInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/recyclebin/restore", query, AliyunDriveResponse.GenericMessageInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileDeleteInfo> fileDelete(final AliyunDriveRequest.FileDeleteInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/delete", query, AliyunDriveResponse.FileDeleteInfo.class, 2).mockResultOnSuccess((AliyunDriveCall.MockResultCallback)new AliyunDriveCall.MockResultCallback<AliyunDriveResponse.FileDeleteInfo>(){

            public AliyunDriveResponse.FileDeleteInfo onSuccess(AliyunDriveResponse.FileDeleteInfo res) {
                if (res == null) {
                    res = new AliyunDriveResponse.FileDeleteInfo();
                    res.setFileId(query.getFileId());
                    res.setDriveId(query.getDriveId());
                    res.setAsyncTaskId("");
                }
                return res;
            }
        });
    }

    public AliyunDriveCall<AliyunDriveResponse.VideoPreviewPlayInfo> videoPreviewPlayInfo(AliyunDriveRequest.VideoPreviewPlayInfo query) {
        AliyunDriveResponse.VideoPreviewPlayInfo info = new AliyunDriveResponse.VideoPreviewPlayInfo();
        info.setCode("WebApiUnsupportedPreview");
        info.setMessage("WebApi not support preview");
        return new AliyunDriveCall((AliyunDriveResponse.GenericMessageInfo)info);
    }

    public Call upload(String url, byte[] bytes, int offset, int byteCount) {
        Request request = new Request.Builder().addHeader("x-authenticate!!", "1").addHeader("x-skip-http-log", "1").put(RequestBody.create((MediaType)MediaType.parse((String)""), (byte[])bytes, (int)offset, (int)byteCount)).url(url).build();
        return this.mOkHttpClient.newCall(request);
    }

    public Call download(String url, String range, String ifRange) {
        Request.Builder builder = new Request.Builder();
        builder.addHeader("x-skip-http-log", "1");
        builder.addHeader("x-skip-http-log", "1");
        if (range != null) {
            builder.header("range", range);
        }
        if (ifRange != null) {
            builder.header("if-range", ifRange);
        }
        Request request = builder.url(url).build();
        return this.mOkHttpClient.newCall(request);
    }

    public Map<String, String> getCommonHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        String deviceId = this.onAuthorizerEvent("Web.AcquireDeviceId", String.class);
        String signature = this.onAuthorizerEvent("Web.AcquireSessionSignature", String.class);
        map.put("User-Agent", AliyunDriveWebConstant.USER_AGENT);
        map.put("x-device-id", deviceId);
        map.put("x-signature", signature + "01");
        map.put("x-canary", "client=web,app=adrive,version=v3.17.0");
        map.put("x-request-id", UUID.randomUUID().toString());
        AliyunDriveResponse.AccessTokenInfo info = this.mAccessTokenInfo;
        if (info != null) {
            map.put("authorization", info.getTokenType() + " " + info.getAccessToken());
        }
        map.put("referer", "https://www.aliyundrive.com/");
        return map;
    }

    public AliyunDriveCall<AliyunDriveWebResponse.ShareTokenInfo> shareToken(AliyunDriveWebRequest.ShareTokenInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/share_link/get_share_token", query, AliyunDriveWebResponse.ShareTokenInfo.class, 1);
    }

    public AliyunDriveCall<AliyunDriveResponse.FileListInfo> shareList(AliyunDriveWebRequest.ShareListInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/adrive/v2/file/list_by_share", (Object)query, AliyunDriveResponse.FileListInfo.class, 1);
    }

    public AliyunDriveCall<AliyunDriveWebResponse.ShareSaveInfo> shareSave(AliyunDriveWebRequest.ShareSaveInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/v2/file/copy", (Object)query, AliyunDriveWebResponse.ShareSaveInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveFileInfo> shareGetFile(AliyunDriveWebRequest.ShareGetFileInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/adrive/v2/file/get_by_share", (Object)query, AliyunDriveFileInfo.class, 1);
    }

    public AliyunDriveCall<AliyunDriveWebResponse.ShareTokenInfo> directTransferToken(AliyunDriveWebRequest.ShareTokenInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/adrive/v1/share/getShareToken", query, AliyunDriveWebResponse.ShareTokenInfo.class, 1);
    }

    public AliyunDriveCall<AliyunDriveWebResponse.DirectTransferSaveInfo> directTransferSave(AliyunDriveWebRequest.DirectTransferSaveInfo query) {
        return this.postApiRequest("https://api.aliyundrive.com/adrive/v1/share/saveFile", (Object)query, AliyunDriveWebResponse.DirectTransferSaveInfo.class, 2);
    }

    public AliyunDriveCall<AliyunDriveWebResponse.DirectTransferGetFileInfo> directTransferGetFile(AliyunDriveWebRequest.DirectTransferGetFileInfo query) {
        query.setSkipShareToken(true);
        return this.postApiRequest("https://api.aliyundrive.com/adrive/v1/share/getByAnonymous", (Object)query, AliyunDriveWebResponse.DirectTransferGetFileInfo.class, 1);
    }

    public <T extends AliyunDriveResponse.GenericMessageInfo> AliyunDriveWebCall<T> postApiRequest(String url, Class<? extends AliyunDriveResponse.GenericMessageInfo> classOfT, int flags) {
        return this.postApiRequest(url, null, classOfT, flags);
    }

    public <T extends AliyunDriveResponse.GenericMessageInfo> AliyunDriveWebCall<T> postApiRequest(String url, Object object, Class<T> classOfT, int flags) {
        AliyunDriveWebShareRequestInfo shareRequestInfo;
        Request.Builder builder = new Request.Builder();
        if (object instanceof AliyunDriveWebShareRequestInfo && !(shareRequestInfo = (AliyunDriveWebShareRequestInfo)((Object)object)).isSkipShareToken()) {
            String shareToken = shareRequestInfo.getShareToken();
            if (StringUtils.isEmpty((String)shareToken)) {
                throw new IllegalArgumentException("share_token is required");
            }
            builder.addHeader("X-Share-Token", shareToken);
        }
        builder.url(url);
        if (object == null) {
            builder.post(RequestBody.create((MediaType)JSON, (String)"{}"));
        } else {
            builder.post(RequestBody.create((MediaType)JSON, (String)JsonUtils.toJson((Object)object)));
        }
        if ((2 & flags) != 0) {
            builder.addHeader("x-authenticate!!", "1");
        }
        return new AliyunDriveWebCall(this.mOkHttpClient.newCall(builder.build()), classOfT);
    }

    public AliyunDriveResponse.AccessTokenInfo getAccessTokenInfo() {
        return this.mAccessTokenInfo;
    }
}

