/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.http.adapter.javax;

import com.fujieid.jap.http.JapHttpCookie;
import com.fujieid.jap.http.JapHttpRequest;
import com.fujieid.jap.http.JapHttpSession;
import com.fujieid.jap.http.JapPart;
import com.fujieid.jap.http.adapter.javax.JavaxCookieAdapter;
import com.fujieid.jap.http.adapter.javax.JavaxJapPart;
import com.fujieid.jap.http.adapter.javax.JavaxSessionAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;

public class JavaxRequestAdapter
implements JapHttpRequest {
    private final HttpServletRequest request;

    public JavaxRequestAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public Object getSource() {
        return this.request;
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public String getRequestUri() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestUrl() {
        return this.request.getRequestURL();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public JapHttpCookie[] getCookies() {
        Cookie[] cookies = this.request.getCookies();
        if (null == cookies || cookies.length == 0) {
            return null;
        }
        int cookieLen = cookies.length;
        JapHttpCookie[] japHttpCookies = new JavaxCookieAdapter[cookieLen];
        for (int i = 0; i < cookieLen; ++i) {
            japHttpCookies[i] = new JavaxCookieAdapter(cookies[i]);
        }
        return japHttpCookies;
    }

    public JapHttpSession getSession() {
        return new JavaxSessionAdapter(this.request.getSession());
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Object getServletContextAttribute(String name) {
        return this.request.getServletContext().getAttribute(name);
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public long getContentLength() {
        return this.request.getContentLength();
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Enumeration<String> getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public Enumeration<String> getParameterNames() {
        return this.request.getParameterNames();
    }

    public Collection<JapPart> getParts() throws IOException {
        try {
            ArrayList<JapPart> japParts = new ArrayList<JapPart>();
            Collection parts = this.request.getParts();
            for (Part part : parts) {
                japParts.add(new JavaxJapPart(part));
            }
            return japParts;
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
    }

    public JapPart getPart(String name) throws IOException {
        try {
            Part part = this.request.getPart(name);
            if (part == null) {
                return null;
            }
            return new JavaxJapPart(part);
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }
}

