/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.http.adapter.javax;

import com.fujieid.jap.http.JapHttpCookie;
import com.fujieid.jap.http.JapHttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class JavaxResponseAdapter
implements JapHttpResponse {
    private final HttpServletResponse response;

    public JavaxResponseAdapter(HttpServletResponse response) {
        this.response = response;
    }

    public Object getSource() {
        return this.response;
    }

    public JapHttpResponse delCookie(String name) {
        this.addCookie(null);
        return this;
    }

    private void addCookie(JapHttpCookie cookie) {
        if (null == cookie) {
            this.addCookie(null, null, null, null, 0, false, false);
            return;
        }
        this.addCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getMaxAge(), cookie.isSecure(), cookie.isHttpOnly());
    }

    public JapHttpResponse addCookie(String name, String value, String path, String domain, int expiry, boolean secure, boolean isHttpOnly) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setDomain(null == domain || domain.length() == 0 ? "/" : domain);
        cookie.setMaxAge(expiry);
        cookie.setSecure(secure);
        cookie.setHttpOnly(isHttpOnly);
        this.response.addCookie(cookie);
        return this;
    }

    public JapHttpResponse setStatus(int status) {
        this.response.setStatus(status);
        return this;
    }

    public JapHttpResponse addHeader(String name, String value) {
        this.response.addHeader(name, value);
        return this;
    }

    public JapHttpResponse setContentType(String contentType) {
        this.response.setContentType(contentType);
        return this;
    }

    public JapHttpResponse setContentLength(int len) {
        this.response.setContentLength(len);
        return this;
    }

    public void write(String html) {
        try {
            try {
                this.response.getOutputStream().write(html.getBytes(StandardCharsets.UTF_8));
            }
            catch (IllegalStateException e) {
                this.response.getWriter().write(html);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public void redirect(String url) {
        try {
            this.response.sendRedirect(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendError(int sc) throws IOException {
        this.response.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.response.sendError(sc, msg);
    }

    public Writer getWriter() throws IOException {
        return this.response.getWriter();
    }

    public void setCharacterEncoding(String charset) {
        this.response.setCharacterEncoding(charset);
    }

    public String encodeRedirectURL(String url) {
        return this.response.encodeRedirectURL(url);
    }

    public void sendRedirect(String location) throws IOException {
        this.response.sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        this.response.setDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public void setContentLengthLong(long len) {
        this.response.setHeader("Content-Length", String.valueOf(len));
    }
}

