/*
 * Decompiled with CFR 0.152.
 */
package net.xfantome.rain;

import java.io.Serializable;
import java.util.List;
import lombok.NonNull;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;

public class RainSheet<T>
implements Serializable {
    private String name;
    private Font font;
    private CellStyle cellStyle;
    private int sheetIndex;
    private boolean insertDateInName;
    @NonNull
    private Class target;
    @NonNull
    private List<T> rowContent;
    private boolean headerStyleApplied;
    private short foregroundColor;
    private int columnWidth;
    private String fontName;
    private short fontColor;
    private boolean fontBold;
    private FillPatternType fillPatternType;

    private static <T> int $default$sheetIndex() {
        return 0;
    }

    private static <T> boolean $default$insertDateInName() {
        return true;
    }

    private static <T> boolean $default$headerStyleApplied() {
        return true;
    }

    private static <T> short $default$foregroundColor() {
        return HSSFColor.HSSFColorPredefined.DARK_GREEN.getIndex();
    }

    private static <T> int $default$columnWidth() {
        return 40;
    }

    private static <T> String $default$fontName() {
        return "Arial";
    }

    private static <T> short $default$fontColor() {
        return HSSFColor.HSSFColorPredefined.WHITE.getIndex();
    }

    private static <T> boolean $default$fontBold() {
        return true;
    }

    private static <T> FillPatternType $default$fillPatternType() {
        return FillPatternType.SOLID_FOREGROUND;
    }

    public static <T> RainSheetBuilder<T> builder() {
        return new RainSheetBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Font getFont() {
        return this.font;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public boolean isInsertDateInName() {
        return this.insertDateInName;
    }

    @NonNull
    public Class getTarget() {
        return this.target;
    }

    @NonNull
    public List<T> getRowContent() {
        return this.rowContent;
    }

    public boolean isHeaderStyleApplied() {
        return this.headerStyleApplied;
    }

    public short getForegroundColor() {
        return this.foregroundColor;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public String getFontName() {
        return this.fontName;
    }

    public short getFontColor() {
        return this.fontColor;
    }

    public boolean isFontBold() {
        return this.fontBold;
    }

    public FillPatternType getFillPatternType() {
        return this.fillPatternType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public void setInsertDateInName(boolean insertDateInName) {
        this.insertDateInName = insertDateInName;
    }

    public void setTarget(@NonNull Class target) {
        if (target == null) {
            throw new NullPointerException("target is marked @NonNull but is null");
        }
        this.target = target;
    }

    public void setRowContent(@NonNull List<T> rowContent) {
        if (rowContent == null) {
            throw new NullPointerException("rowContent is marked @NonNull but is null");
        }
        this.rowContent = rowContent;
    }

    public void setHeaderStyleApplied(boolean headerStyleApplied) {
        this.headerStyleApplied = headerStyleApplied;
    }

    public void setForegroundColor(short foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontColor(short fontColor) {
        this.fontColor = fontColor;
    }

    public void setFontBold(boolean fontBold) {
        this.fontBold = fontBold;
    }

    public void setFillPatternType(FillPatternType fillPatternType) {
        this.fillPatternType = fillPatternType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RainSheet)) {
            return false;
        }
        RainSheet other = (RainSheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Font this$font = this.getFont();
        Font other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        CellStyle this$cellStyle = this.getCellStyle();
        CellStyle other$cellStyle = other.getCellStyle();
        if (this$cellStyle == null ? other$cellStyle != null : !this$cellStyle.equals(other$cellStyle)) {
            return false;
        }
        if (this.getSheetIndex() != other.getSheetIndex()) {
            return false;
        }
        if (this.isInsertDateInName() != other.isInsertDateInName()) {
            return false;
        }
        Class this$target = this.getTarget();
        Class other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        List<T> this$rowContent = this.getRowContent();
        List<T> other$rowContent = other.getRowContent();
        if (this$rowContent == null ? other$rowContent != null : !((Object)this$rowContent).equals(other$rowContent)) {
            return false;
        }
        if (this.isHeaderStyleApplied() != other.isHeaderStyleApplied()) {
            return false;
        }
        if (this.getForegroundColor() != other.getForegroundColor()) {
            return false;
        }
        if (this.getColumnWidth() != other.getColumnWidth()) {
            return false;
        }
        String this$fontName = this.getFontName();
        String other$fontName = other.getFontName();
        if (this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName)) {
            return false;
        }
        if (this.getFontColor() != other.getFontColor()) {
            return false;
        }
        if (this.isFontBold() != other.isFontBold()) {
            return false;
        }
        FillPatternType this$fillPatternType = this.getFillPatternType();
        FillPatternType other$fillPatternType = other.getFillPatternType();
        return !(this$fillPatternType == null ? other$fillPatternType != null : !this$fillPatternType.equals(other$fillPatternType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RainSheet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Font $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        CellStyle $cellStyle = this.getCellStyle();
        result = result * 59 + ($cellStyle == null ? 43 : $cellStyle.hashCode());
        result = result * 59 + this.getSheetIndex();
        result = result * 59 + (this.isInsertDateInName() ? 79 : 97);
        Class $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        List<T> $rowContent = this.getRowContent();
        result = result * 59 + ($rowContent == null ? 43 : ((Object)$rowContent).hashCode());
        result = result * 59 + (this.isHeaderStyleApplied() ? 79 : 97);
        result = result * 59 + this.getForegroundColor();
        result = result * 59 + this.getColumnWidth();
        String $fontName = this.getFontName();
        result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
        result = result * 59 + this.getFontColor();
        result = result * 59 + (this.isFontBold() ? 79 : 97);
        FillPatternType $fillPatternType = this.getFillPatternType();
        result = result * 59 + ($fillPatternType == null ? 43 : $fillPatternType.hashCode());
        return result;
    }

    public RainSheet(String name, Font font, CellStyle cellStyle, int sheetIndex, boolean insertDateInName, @NonNull Class target, @NonNull List<T> rowContent, boolean headerStyleApplied, short foregroundColor, int columnWidth, String fontName, short fontColor, boolean fontBold, FillPatternType fillPatternType) {
        if (target == null) {
            throw new NullPointerException("target is marked @NonNull but is null");
        }
        if (rowContent == null) {
            throw new NullPointerException("rowContent is marked @NonNull but is null");
        }
        this.name = name;
        this.font = font;
        this.cellStyle = cellStyle;
        this.sheetIndex = sheetIndex;
        this.insertDateInName = insertDateInName;
        this.target = target;
        this.rowContent = rowContent;
        this.headerStyleApplied = headerStyleApplied;
        this.foregroundColor = foregroundColor;
        this.columnWidth = columnWidth;
        this.fontName = fontName;
        this.fontColor = fontColor;
        this.fontBold = fontBold;
        this.fillPatternType = fillPatternType;
    }

    public RainSheet(@NonNull Class target, @NonNull List<T> rowContent) {
        if (target == null) {
            throw new NullPointerException("target is marked @NonNull but is null");
        }
        if (rowContent == null) {
            throw new NullPointerException("rowContent is marked @NonNull but is null");
        }
        this.target = target;
        this.rowContent = rowContent;
        this.sheetIndex = RainSheet.$default$sheetIndex();
        this.insertDateInName = RainSheet.$default$insertDateInName();
        this.headerStyleApplied = RainSheet.$default$headerStyleApplied();
        this.foregroundColor = RainSheet.$default$foregroundColor();
        this.columnWidth = RainSheet.$default$columnWidth();
        this.fontName = RainSheet.$default$fontName();
        this.fontColor = RainSheet.$default$fontColor();
        this.fontBold = RainSheet.$default$fontBold();
        this.fillPatternType = RainSheet.$default$fillPatternType();
    }

    public String toString() {
        return "RainSheet(name=" + this.getName() + ", font=" + this.getFont() + ", cellStyle=" + this.getCellStyle() + ", sheetIndex=" + this.getSheetIndex() + ", insertDateInName=" + this.isInsertDateInName() + ", target=" + this.getTarget() + ", rowContent=" + this.getRowContent() + ", headerStyleApplied=" + this.isHeaderStyleApplied() + ", foregroundColor=" + this.getForegroundColor() + ", columnWidth=" + this.getColumnWidth() + ", fontName=" + this.getFontName() + ", fontColor=" + this.getFontColor() + ", fontBold=" + this.isFontBold() + ", fillPatternType=" + this.getFillPatternType() + ")";
    }

    public static class RainSheetBuilder<T> {
        private String name;
        private Font font;
        private CellStyle cellStyle;
        private boolean sheetIndex$set;
        private int sheetIndex;
        private boolean insertDateInName$set;
        private boolean insertDateInName;
        private Class target;
        private List<T> rowContent;
        private boolean headerStyleApplied$set;
        private boolean headerStyleApplied;
        private boolean foregroundColor$set;
        private short foregroundColor;
        private boolean columnWidth$set;
        private int columnWidth;
        private boolean fontName$set;
        private String fontName;
        private boolean fontColor$set;
        private short fontColor;
        private boolean fontBold$set;
        private boolean fontBold;
        private boolean fillPatternType$set;
        private FillPatternType fillPatternType;

        RainSheetBuilder() {
        }

        public RainSheetBuilder<T> name(String name) {
            this.name = name;
            return this;
        }

        public RainSheetBuilder<T> font(Font font) {
            this.font = font;
            return this;
        }

        public RainSheetBuilder<T> cellStyle(CellStyle cellStyle) {
            this.cellStyle = cellStyle;
            return this;
        }

        public RainSheetBuilder<T> sheetIndex(int sheetIndex) {
            this.sheetIndex = sheetIndex;
            this.sheetIndex$set = true;
            return this;
        }

        public RainSheetBuilder<T> insertDateInName(boolean insertDateInName) {
            this.insertDateInName = insertDateInName;
            this.insertDateInName$set = true;
            return this;
        }

        public RainSheetBuilder<T> target(@NonNull Class target) {
            if (target == null) {
                throw new NullPointerException("target is marked @NonNull but is null");
            }
            this.target = target;
            return this;
        }

        public RainSheetBuilder<T> rowContent(@NonNull List<T> rowContent) {
            if (rowContent == null) {
                throw new NullPointerException("rowContent is marked @NonNull but is null");
            }
            this.rowContent = rowContent;
            return this;
        }

        public RainSheetBuilder<T> headerStyleApplied(boolean headerStyleApplied) {
            this.headerStyleApplied = headerStyleApplied;
            this.headerStyleApplied$set = true;
            return this;
        }

        public RainSheetBuilder<T> foregroundColor(short foregroundColor) {
            this.foregroundColor = foregroundColor;
            this.foregroundColor$set = true;
            return this;
        }

        public RainSheetBuilder<T> columnWidth(int columnWidth) {
            this.columnWidth = columnWidth;
            this.columnWidth$set = true;
            return this;
        }

        public RainSheetBuilder<T> fontName(String fontName) {
            this.fontName = fontName;
            this.fontName$set = true;
            return this;
        }

        public RainSheetBuilder<T> fontColor(short fontColor) {
            this.fontColor = fontColor;
            this.fontColor$set = true;
            return this;
        }

        public RainSheetBuilder<T> fontBold(boolean fontBold) {
            this.fontBold = fontBold;
            this.fontBold$set = true;
            return this;
        }

        public RainSheetBuilder<T> fillPatternType(FillPatternType fillPatternType) {
            this.fillPatternType = fillPatternType;
            this.fillPatternType$set = true;
            return this;
        }

        public RainSheet<T> build() {
            int sheetIndex = this.sheetIndex;
            if (!this.sheetIndex$set) {
                sheetIndex = RainSheet.$default$sheetIndex();
            }
            boolean insertDateInName = this.insertDateInName;
            if (!this.insertDateInName$set) {
                insertDateInName = RainSheet.$default$insertDateInName();
            }
            boolean headerStyleApplied = this.headerStyleApplied;
            if (!this.headerStyleApplied$set) {
                headerStyleApplied = RainSheet.$default$headerStyleApplied();
            }
            short foregroundColor = this.foregroundColor;
            if (!this.foregroundColor$set) {
                foregroundColor = RainSheet.$default$foregroundColor();
            }
            int columnWidth = this.columnWidth;
            if (!this.columnWidth$set) {
                columnWidth = RainSheet.$default$columnWidth();
            }
            String fontName = this.fontName;
            if (!this.fontName$set) {
                fontName = RainSheet.$default$fontName();
            }
            short fontColor = this.fontColor;
            if (!this.fontColor$set) {
                fontColor = RainSheet.$default$fontColor();
            }
            boolean fontBold = this.fontBold;
            if (!this.fontBold$set) {
                fontBold = RainSheet.$default$fontBold();
            }
            FillPatternType fillPatternType = this.fillPatternType;
            if (!this.fillPatternType$set) {
                fillPatternType = RainSheet.$default$fillPatternType();
            }
            return new RainSheet<T>(this.name, this.font, this.cellStyle, sheetIndex, insertDateInName, this.target, this.rowContent, headerStyleApplied, foregroundColor, columnWidth, fontName, fontColor, fontBold, fillPatternType);
        }

        public String toString() {
            return "RainSheet.RainSheetBuilder(name=" + this.name + ", font=" + this.font + ", cellStyle=" + this.cellStyle + ", sheetIndex=" + this.sheetIndex + ", insertDateInName=" + this.insertDateInName + ", target=" + this.target + ", rowContent=" + this.rowContent + ", headerStyleApplied=" + this.headerStyleApplied + ", foregroundColor=" + this.foregroundColor + ", columnWidth=" + this.columnWidth + ", fontName=" + this.fontName + ", fontColor=" + this.fontColor + ", fontBold=" + this.fontBold + ", fillPatternType=" + this.fillPatternType + ")";
        }
    }
}

