/*
 * Decompiled with CFR 0.152.
 */
package net.xfantome.rain;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import net.xfantome.rain.RainRow;
import net.xfantome.rain.RainSheet;
import net.xfantome.rain.RainTemplate;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkBookGenerator<T> {
    private static final Logger log = Logger.getLogger(WorkBookGenerator.class.getName());
    private CellStyle style;
    private List<Field> fields = new ArrayList<Field>();
    private RainSheet<T> rainSheet;
    private List<String> headers;
    private String name;
    private String creationDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd-MM-yyyy hh mm ss"));
    private XSSFWorkbook workbook;

    public WorkBookGenerator(RainSheet<T> rainSheet) {
        this.rainSheet = rainSheet;
        this.headers = new ArrayList<String>();
        this.rowsName();
        this.name = this.sheetName();
        this.workbook = new XSSFWorkbook();
        this.rainSheet.setName(this.getName());
        this.style = RainTemplate.headerStyle(this.workbook, this.rainSheet);
    }

    private static String upperCaseFirstLetter(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    private String sheetName() {
        if (this.rainSheet.isInsertDateInName()) {
            return this.creationDate + "_" + this.name();
        }
        return this.name();
    }

    private String name() {
        return this.rainSheet.getName() == null ? this.rainSheet.getTarget().getSimpleName() : this.rainSheet.getName();
    }

    public Workbook render() {
        Sheet sheet = this.createHeader(this.headers);
        this.Content(sheet);
        return this.workbook;
    }

    private Sheet createHeader(List<String> rowNames) {
        XSSFSheet sheet = this.workbook.getSheetAt(0);
        Row header = sheet.createRow(0);
        for (int i = 0; i < rowNames.size(); ++i) {
            header.createCell(i).setCellValue(rowNames.get(i));
            if (!this.rainSheet.isHeaderStyleApplied()) continue;
            header.getCell(i).setCellStyle(this.style);
        }
        return sheet;
    }

    private void supperClassFields(Class clazz) {
        if (clazz.getSuperclass() == null) {
            return;
        }
        this.fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        this.supperClassFields(clazz.getSuperclass());
    }

    private List<String> rowsName() {
        this.fields.addAll(Arrays.asList(this.rainSheet.getTarget().getDeclaredFields()));
        this.supperClassFields(this.rainSheet.getTarget().getSuperclass());
        for (Field field : this.fields) {
            RainRow rowName = field.getAnnotation(RainRow.class);
            if (rowName == null || !rowName.include()) continue;
            String name = WorkBookGenerator.upperCaseFirstLetter(rowName.name().trim().equals("") ? field.getName() : rowName.name());
            this.headers.add(name);
        }
        return this.headers;
    }

    private List<Field> itemField(Class clazz) {
        ArrayList<Field> f = new ArrayList<Field>();
        f.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (Class superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            f.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        return f;
    }

    private void Content(Sheet sheet) {
        int[] rowCount = new int[]{1};
        rowCount[0] = 1;
        this.rainSheet.getRowContent().stream().forEach(c -> {
            try {
                int n = rowCount[0];
                rowCount[0] = n + 1;
                Row row = sheet.createRow(n);
                List<Field> fields = this.itemField(c.getClass());
                BeanInfo info = Introspector.getBeanInfo(c.getClass(), Object.class);
                PropertyDescriptor[] props = info.getPropertyDescriptors();
                int k = 0;
                for (Field field : fields) {
                    RainRow annotation = field.getAnnotation(RainRow.class);
                    field.setAccessible(true);
                    if (annotation == null || !annotation.include()) continue;
                    Object value = annotation.child().length > 0 ? this.childs(annotation.child(), c, props, field.getName()) : this.getFiledValue(c, props, field.getName());
                    row.createCell(k).setCellValue(value != null ? String.valueOf(value) : "");
                    ++k;
                }
            }
            catch (IntrospectionException e) {
                log.info(e.getMessage());
            }
        });
    }

    private Object childs(String[] childName, T c, PropertyDescriptor[] props, String fieldName) {
        Object value = this.getFiledValue(c, props, fieldName);
        String result = "";
        try {
            BeanInfo info = Introspector.getBeanInfo(value.getClass(), Object.class);
            PropertyDescriptor[] pp = info.getPropertyDescriptors();
            for (int i = 0; i < childName.length; ++i) {
                result = result + childName[i] + " : " + this.getFiledValue(value, pp, childName[i]) + "; ";
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Object getFiledValue(T c, PropertyDescriptor[] props, String fieldName) {
        Object value = null;
        try {
            for (PropertyDescriptor pd : props) {
                String name = pd.getName();
                if (!name.equals(fieldName)) continue;
                Method getter = pd.getReadMethod();
                value = getter.invoke(c, new Object[0]);
                break;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.info(e.getMessage());
        }
        return value;
    }

    private Object getFiledType(PropertyDescriptor[] props, String fieldName) {
        Class<?> type = null;
        for (PropertyDescriptor pd : props) {
            String name = pd.getName();
            if (!name.equals(fieldName)) continue;
            type = pd.getPropertyType();
            break;
        }
        return type;
    }

    public CellStyle getStyle() {
        return this.style;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public RainSheet<T> getRainSheet() {
        return this.rainSheet;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public String getName() {
        return this.name;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public XSSFWorkbook getWorkbook() {
        return this.workbook;
    }
}

