/*
 * Decompiled with CFR 0.152.
 */
package net.yadaframework.commerce.persistence.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import net.yadaframework.commerce.persistence.entity.YadaOrder;
import net.yadaframework.persistence.YadaMoney;
import net.yadaframework.persistence.YadaMoneyConverter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public class YadaOrderItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(insertable=false, updatable=false, columnDefinition="DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date modified;
    @Version
    protected long version;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    protected int quantity;
    @Convert(converter=YadaMoneyConverter.class)
    protected YadaMoney unitPrice;
    protected String articleCode;
    @ManyToOne(optional=false)
    protected YadaOrder order;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public YadaMoney getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(YadaMoney unitPrice) {
        this.unitPrice = unitPrice;
    }

    public YadaOrder getOrder() {
        return this.order;
    }

    public void setOrder(YadaOrder order) {
        this.order = order;
    }

    public String getArticleCode() {
        return this.articleCode;
    }

    public void setArticleCode(String articleCode) {
        this.articleCode = articleCode;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public long getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        YadaOrderItem other = (YadaOrderItem)obj;
        return Objects.equals(this.id, other.id);
    }
}

