/*
 * Decompiled with CFR 0.152.
 */
package net.yadaframework.commerce.persistence.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;
import net.yadaframework.commerce.persistence.entity.YadaOrder;
import net.yadaframework.components.YadaUtil;
import net.yadaframework.persistence.YadaMoney;
import net.yadaframework.persistence.YadaMoneyConverter;
import net.yadaframework.security.persistence.entity.YadaUserProfile;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public class YadaTransaction {
    @Column(insertable=false, updatable=false, columnDefinition="DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date modified;
    @Version
    protected long version;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    @ManyToOne(optional=true)
    protected YadaUserProfile accountOwner;
    @ManyToOne(optional=true)
    protected YadaUserProfile otherParty;
    @Convert(converter=YadaMoneyConverter.class)
    @Column(nullable=false)
    protected YadaMoney amount;
    @Column(length=8)
    protected String currencyCode;
    @Column(columnDefinition="TIMESTAMP NULL")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date timestamp;
    @Column(length=32)
    protected String status;
    protected String transactionId;
    protected String payerId1;
    protected String payerId2;
    protected String description;
    @Column(length=32)
    protected String paymentSystem;
    @Column(length=8192)
    protected String data;
    @OneToOne
    protected YadaOrder order;
    protected Boolean inverse = false;
    protected Boolean suspended = false;
    protected Boolean external = false;

    public String getTimestampAsRelative(Locale locale) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(this.timestamp.toInstant(), this.accountOwner.getTimezone().toZoneId());
        return YadaUtil.INSTANCE.getTimestampAsRelative(zonedDateTime, locale, null);
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public YadaUserProfile getAccountOwner() {
        return this.accountOwner;
    }

    public void setAccountOwner(YadaUserProfile payer) {
        this.accountOwner = payer;
    }

    public YadaUserProfile getOtherParty() {
        return this.otherParty;
    }

    public void setOtherParty(YadaUserProfile payee) {
        this.otherParty = payee;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public YadaMoney getAmount() {
        return this.amount;
    }

    public void setAmount(YadaMoney amount) {
        this.amount = amount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public YadaOrder getOrder() {
        return this.order;
    }

    public void setOrder(YadaOrder order) {
        this.order = order;
    }

    public String getPayerId1() {
        return this.payerId1;
    }

    public void setPayerId1(String payerId1) {
        this.payerId1 = payerId1;
    }

    public String getPayerId2() {
        return this.payerId2;
    }

    public void setPayerId2(String payerId2) {
        this.payerId2 = payerId2;
    }

    public Boolean getInverse() {
        return this.inverse;
    }

    public void setInverse(Boolean inverse) {
        this.inverse = inverse;
    }

    public String getPaymentSystem() {
        return this.paymentSystem;
    }

    public void setPaymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
    }

    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public Boolean getExternal() {
        return this.external;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }
}

