/*
 * Decompiled with CFR 0.152.
 */
package net.yadaframework.commerce.persistence.repository;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Date;
import java.util.List;
import net.yadaframework.commerce.persistence.entity.YadaOrder;
import net.yadaframework.commerce.persistence.entity.YadaOrderItem;
import net.yadaframework.commerce.persistence.entity.YadaOrderStatus;
import net.yadaframework.components.YadaUtil;
import net.yadaframework.persistence.YadaSql;
import net.yadaframework.security.persistence.entity.YadaUserProfile;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class YadaOrderDao {
    @PersistenceContext
    private EntityManager em;

    public List<YadaOrderItem> find(YadaUserProfile owner, String articleCode) {
        return YadaSql.instance().selectFrom("select yoi from YadaOrderItem yoi").join("join yoi.order yo").where("yo.owner = :owner").and().where("yoi.articleCode = :articleCode").orderBy("yoi.modified desc").setParameter("owner", (Object)owner).setParameter("articleCode", (Object)articleCode).query(this.em, YadaOrderItem.class).getResultList();
    }

    @Transactional(readOnly=false)
    public void cleanup() {
        this.cleanup(20);
    }

    @Transactional(readOnly=false)
    public void cleanup(int daysPassed) {
        Date thePast = YadaUtil.addDays((Date)new Date(), (int)(-daysPassed));
        String sql = "select yo from YadaOrder yo where yo.modified < :someDate and yo.orderStatus = :someStatus";
        List resultList = this.em.createQuery(sql, YadaOrder.class).setParameter("someDate", (Object)thePast).setParameter("someStatus", YadaOrderStatus.UNPAID.toYadaPersistentEnum()).getResultList();
        for (YadaOrder yadaOrder : resultList) {
            this.em.remove((Object)yadaOrder);
        }
    }

    @Transactional(readOnly=false)
    public YadaOrderItem save(YadaOrderItem entity) {
        if (entity.getId() == null) {
            this.em.persist((Object)entity);
        } else {
            entity = (YadaOrderItem)this.em.merge((Object)entity);
        }
        return entity;
    }

    @Transactional(readOnly=false)
    public YadaOrder save(YadaOrder yadaOrder) {
        if (yadaOrder.getId() == null) {
            this.em.persist((Object)yadaOrder);
        } else {
            yadaOrder = (YadaOrder)this.em.merge((Object)yadaOrder);
        }
        return yadaOrder;
    }
}

