/*
 * Decompiled with CFR 0.152.
 */
package net.yadaframework.commerce.persistence.repository;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import net.yadaframework.commerce.persistence.entity.YadaOrder;
import net.yadaframework.commerce.persistence.entity.YadaTransaction;
import net.yadaframework.persistence.YadaMoney;
import net.yadaframework.persistence.YadaSql;
import net.yadaframework.security.persistence.entity.YadaUserProfile;
import net.yadaframework.web.YadaPageRequest;
import net.yadaframework.web.YadaPageRows;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class YadaTransactionDao {
    @PersistenceContext
    private EntityManager em;

    public YadaMoney sumAmount(@Nullable YadaUserProfile accountOwner) {
        Long sum = (Long)YadaSql.instance().selectFrom("select SUM(amount) from YadaTransaction").where(accountOwner != null, "where accountOwner=:accountOwner").setParameter("accountOwner", (Object)accountOwner).query(this.em).getSingleResult();
        YadaMoney result = YadaMoney.fromDatabaseColumn((Long)sum);
        return result;
    }

    @Transactional(readOnly=false)
    public YadaTransaction createInverse(YadaTransaction payment) {
        payment = (YadaTransaction)this.em.merge((Object)payment);
        payment.setInverse(false);
        YadaTransaction yadaTransaction = new YadaTransaction();
        yadaTransaction.setAmount(payment.getAmount().getNegated());
        yadaTransaction.setCurrencyCode(payment.getCurrencyCode());
        yadaTransaction.setAccountOwner(payment.getOtherParty());
        yadaTransaction.setOtherParty(payment.getAccountOwner());
        yadaTransaction.setTransactionId(payment.getTransactionId());
        yadaTransaction.setTimestamp(payment.getTimestamp());
        yadaTransaction.setStatus(payment.getStatus());
        yadaTransaction.setDescription(payment.getDescription());
        yadaTransaction.setPayerId1(payment.getPayerId1());
        yadaTransaction.setPayerId2(payment.getPayerId2());
        yadaTransaction.setOrder(payment.getOrder());
        yadaTransaction.setData(payment.getData());
        yadaTransaction.setPaymentSystem(payment.getPaymentSystem());
        yadaTransaction.setInverse(true);
        this.em.persist((Object)yadaTransaction);
        return yadaTransaction;
    }

    @Transactional(readOnly=false)
    public int deleteSuspended(YadaOrder yadaOrder) {
        String sql = "delete from YadaTransaction where order = :yadaOrder and suspended is true";
        return this.em.createQuery(sql).setParameter("yadaOrder", (Object)yadaOrder).executeUpdate();
    }

    public List<YadaTransaction> find(YadaOrder yadaOrder) {
        List found = YadaSql.instance().selectFrom("from YadaTransaction").where("order = :yadaOrder").and().where("inverse != true").and().where("suspended != true").and().setParameter("yadaOrder", (Object)yadaOrder).query(this.em, YadaTransaction.class).getResultList();
        return found;
    }

    public YadaPageRows<YadaTransaction> find(Long userProfileId, YadaPageRequest yadaPageRequest) {
        List found = YadaSql.instance().selectFrom("from YadaTransaction").where("accountOwner.id = :userProfileId").orderBy(yadaPageRequest).setParameter("userProfileId", (Object)userProfileId).query(this.em, YadaTransaction.class).setFirstResult(yadaPageRequest.getFirstResult()).setMaxResults(yadaPageRequest.getMaxResults()).getResultList();
        return new YadaPageRows(found, yadaPageRequest);
    }

    public YadaTransaction find(Long id) {
        if (id == null) {
            return null;
        }
        return (YadaTransaction)this.em.find(YadaTransaction.class, (Object)id);
    }

    @Transactional(readOnly=false)
    public YadaTransaction save(YadaTransaction entity) {
        if (entity.getId() == null) {
            this.em.persist((Object)entity);
        } else {
            entity = (YadaTransaction)this.em.merge((Object)entity);
        }
        return entity;
    }
}

